% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell.R
\name{calcite_shell}
\alias{calcite_shell}
\title{Create a Calcite Shell Layout}
\usage{
calcite_shell(
  ...,
  header = NULL,
  footer = NULL,
  panel_start = NULL,
  panel_end = NULL,
  panel_top = NULL,
  panel_bottom = NULL,
  modals = NULL,
  dialogs = NULL,
  alerts = NULL,
  sheets = NULL
)
}
\arguments{
\item{...}{Main content to display in the default slot (between panels)}

\item{header}{Content for the header slot (top of shell). Typically a
\code{\link[=calcite_navigation]{calcite_navigation()}} component.}

\item{footer}{Content for the footer slot (bottom of shell)}

\item{panel_start}{Content for the start/left panel. Typically a
\code{\link[=calcite_shell_panel]{calcite_shell_panel()}} wrapping a \code{\link[=calcite_panel]{calcite_panel()}}.}

\item{panel_end}{Content for the end/right panel. Typically a
\code{\link[=calcite_shell_panel]{calcite_shell_panel()}} wrapping a \code{\link[=calcite_panel]{calcite_panel()}}.}

\item{panel_top}{Content for the top panel (below header)}

\item{panel_bottom}{Content for the bottom panel (above footer)}

\item{modals}{Slot for \code{\link[=calcite_modal]{calcite_modal()}} components}

\item{dialogs}{Slot for \code{\link[=calcite_dialog]{calcite_dialog()}} components}

\item{alerts}{Slot for \code{\link[=calcite_alert]{calcite_alert()}} components}

\item{sheets}{Slot for \code{\link[=calcite_sheet]{calcite_sheet()}} components}
}
\value{
An object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
The Shell is a foundational layout component in Calcite, enabling the creation
of rich, interactive experiences. It provides structured slots for headers,
footers, side panels, and main content.
}
\details{
\subsection{Shell Structure}{

The shell organizes your application into distinct regions:
\itemize{
\item \strong{header}: Top navigation bar
\item \strong{panel-start/panel-end}: Side panels (left/right)
\item \strong{panel-top/panel-bottom}: Top/bottom panels
\item \strong{Default content}: Main application area (maps, charts, etc.)
\item \strong{footer}: Bottom information/links
\item \strong{Overlay slots}: modals, dialogs, alerts, sheets
}

When embedded within other content, the overlay slots (modals, dialogs, alerts, sheets)
facilitate placement of these components relative to the Shell, constraining them
to the shell's boundaries rather than the full page.
}
}
\examples{
# Basic shell with header and content
calcite_shell(
  header = calcite_navigation(
    calcite_navigation_logo(slot = "logo", heading = "My App")
  ),
  "Main content goes here"
)

# Shell with sidebar panel
calcite_shell(
  panel_start = calcite_shell_panel(
    calcite_panel(heading = "Layers")
  ),
  calcite_panel(heading = "Map View")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/shell/}{Official Documentation}
}
