% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch.R
\name{calcite_switch}
\alias{calcite_switch}
\title{Create a Calcite Switch Component}
\usage{
calcite_switch(
  id = NULL,
  checked = NULL,
  disabled = NULL,
  form = NULL,
  label = NULL,
  label_text_end = NULL,
  label_text_start = NULL,
  name = NULL,
  scale = NULL,
  value = NULL,
  ...
)
}
\arguments{
\item{id}{Optional ID for the switch (required for Shiny reactivity)}

\item{checked}{When TRUE, the component is checked}

\item{disabled}{When TRUE, interaction is prevented and the component is displayed with lower opacity}

\item{form}{The id of the form that will be associated with the component}

\item{label}{Accessible name for the component}

\item{label_text_end}{When provided, displays label text at the end of the component}

\item{label_text_start}{When provided, displays label text at the start of the component}

\item{name}{Specifies the name of the component. Required to pass the component's value on form submission}

\item{scale}{Specifies the size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{value}{The component's value}

\item{...}{Additional attributes passed to the component}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a switch component for "on" and "off" choices. Switches should be used
for boolean choices and can be useful for opt-in and additive actions.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_switch()} returns a reactive list containing
all component properties. You can observe the entire component state or watch
individual properties:

\strong{Available properties:}
\itemize{
\item \verb{$checked} - Whether the switch is currently checked (on/off)
\item \verb{$disabled} - Whether the switch is disabled
\item \verb{$value} - The switch's value
\item \verb{$name} - The component's name
\item Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Watch for changes to the switch
observeEvent(input$my_switch, \{
  print(paste("Switch is:", if(input$my_switch$checked) "ON" else "OFF"))
\})

# Access the checked state directly
observeEvent(input$my_switch$checked, \{
  if (input$my_switch$checked) \{
    print("Switch turned ON")
  \} else \{
    print("Switch turned OFF")
  \}
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic switch
calcite_switch(
  id = "my_switch",
  label = "Enable 3D mode"
)

# Switch with label text on both sides
calcite_switch(
  id = "theme_switch",
  label_text_start = "Light",
  label_text_end = "Dark",
  label = "Theme toggle"
)

# Checked switch at large scale
calcite_switch(
  checked = TRUE,
  scale = "l",
  label = "Notifications"
)

# Shiny example
if (interactive()) {
  library(shiny)

  ui <- calcite_shell(
    calcite_panel(
      heading = "Switch Example",

      calcite_label(
        layout = "inline",
        "3D Off",
        calcite_switch(id = "mode_switch"),
        "3D On"
      ),

      verbatimTextOutput("status")
    )
  )

  server <- function(input, output, session) {
    # Display switch state
    output$status <- renderPrint({
      input$mode_switch
    })
  }

  shinyApp(ui, server)
}
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/switch/}{Official Documentation}
}
