% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{calcite_table}
\alias{calcite_table}
\title{Create a Calcite Table Component}
\usage{
calcite_table(
  data,
  ...,
  id = NULL,
  caption,
  header = NULL,
  alignment = "start",
  bordered = NULL,
  numbered = NULL,
  page_size = NULL,
  scale = NULL,
  striped = NULL,
  numbering_system = NULL
)
}
\arguments{
\item{data}{A data.frame to display in the table (required)}

\item{...}{Additional attributes passed to the component}

\item{id}{Component ID (required for Shiny reactivity)}

\item{caption}{Accessible title for the table (required)}

\item{header}{Custom header row created with \code{\link[=calcite_table_header]{calcite_table_header()}}. If NULL, column names from data are used}

\item{alignment}{Alignment for all cells: "start", "center", or "end" (default: "start")}

\item{bordered}{When TRUE, displays borders (default: FALSE)}

\item{numbered}{When TRUE, displays row numbers (default: FALSE)}

\item{page_size}{Page size for pagination. When > 0, renders pagination controls (default: 0)}

\item{scale}{Size of the component: "s" (small), "m" (medium), or "l" (large) (default: "m")}

\item{striped}{When TRUE, displays striped styling (default: FALSE)}

\item{numbering_system}{Unicode numeral system: "arab", "arabext", or "latn"}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a table component from a data.frame with automatic row and cell generation.
The table provides pagination, numbering, and various styling options.
}
\details{
\subsection{Shiny Integration}{

The table emits events for page changes and selection changes (when selection is enabled).

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$pageSize} - Current page size
\item \verb{$scale} - Component scale
\item \verb{$bordered} - Whether borders are displayed
\item \verb{$numbered} - Whether row numbers are displayed
\item \verb{$striped} - Whether striped styling is applied
\item Other component properties
}

\strong{Events:}
\itemize{
\item \code{calciteTablePageChange} - Fires when the page changes
}
}
}
\examples{
# Basic table from data frame
calcite_table(
  data = mtcars[1:5, 1:4],
  id = "my_table",
  caption = "Motor Trend Car Data",
  bordered = TRUE,
  striped = TRUE
)

# Table with pagination
calcite_table(
  data = iris,
  id = "iris_table",
  caption = "Iris Dataset",
  page_size = 10,
  numbered = TRUE
)

# Table with custom headers
calcite_table(
  data = mtcars[1:5, 1:3],
  caption = "Cars",
  header = list(
    calcite_table_header(heading = "Miles/Gallon", description = "Fuel efficiency"),
    calcite_table_header(heading = "Cylinders", description = "Number of cylinders"),
    calcite_table_header(heading = "Displacement", description = "Engine size")
  )
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/table/}{Official Documentation}
}
