% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile.R
\name{calcite_tile}
\alias{calcite_tile}
\title{Create a Calcite Tile Component}
\usage{
calcite_tile(
  ...,
  id = NULL,
  heading = NULL,
  description = NULL,
  icon = NULL,
  href = NULL,
  active = NULL,
  selected = NULL,
  disabled = NULL,
  alignment = NULL,
  scale = NULL,
  icon_flip_rtl = NULL,
  label = NULL,
  content_top = NULL,
  content_bottom = NULL
)
}
\arguments{
\item{...}{Child content for the tile}

\item{id}{Optional ID for the tile (required for Shiny reactivity)}

\item{heading}{The component header text}

\item{description}{A description for the component, which displays below the heading}

\item{icon}{Specifies an icon to display}

\item{href}{When provided, the URL for the component (makes tile a link)}

\item{active}{When TRUE, the component is active (default: FALSE)}

\item{selected}{When TRUE and parent's selectionMode allows it, component is selected (default: FALSE)}

\item{disabled}{When TRUE, interaction is prevented and component displays with lower opacity (default: FALSE)}

\item{alignment}{Specifies alignment of tile's content: "start" or "center"}

\item{scale}{Specifies size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{icon_flip_rtl}{When TRUE, icon will be flipped when element direction is RTL (default: FALSE)}

\item{label}{Accessible name for the component}

\item{content_top}{Slot for adding non-interactive elements above the component's content}

\item{content_bottom}{Slot for adding non-interactive elements below the component's content}
}
\value{
An object of class \code{calcite_component}
}
\description{
Tiles are presentational components useful for presenting consequential
information in a compact, consistent format. They can contain supportive
icons, a heading, and a description.
}
\details{
\subsection{Best Practices}{
\itemize{
\item Tiles are best used to represent one of a limited number of options, actions, or choices
\item The component is wholly focusable - it should not contain slotted focusable elements
\item Text should be concise (heading max ~50 chars, description max ~175 chars)
\item Use sentence case for heading and description
\item End description with proper punctuation
}
}

\subsection{Shiny Integration}{

When used in a Shiny app with an \code{id}, \code{calcite_tile()} returns a reactive list
containing component properties.

\strong{Available properties:}
\itemize{
\item \verb{$active} - Whether the tile is currently active
\item \verb{$selected} - Whether the tile is selected
\item \verb{$disabled} - Whether the tile is disabled
\item \verb{$heading} - The heading text
\item \verb{$description} - The description text
\item \verb{$icon} - The icon name
\item Other component properties
}
}
}
\examples{
# Basic tile with icon and description
calcite_tile(
  icon = "3d-glasses",
  heading = "Special viewing glasses",
  description = "Great for eclipses and optical illusions"
)

# Tile with content in bottom slot
calcite_tile(
  icon = "rangefinder",
  heading = "Rangefinder",
  description = "A time-tested tool for field engineers",
  content_bottom = calcite_chip("214 in use")
)

# Active tile with link
calcite_tile(
  icon = "data",
  heading = "Data Analysis",
  href = "https://example.com/data",
  active = TRUE
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/tile/}{Official Documentation}
}
