% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile-group.R
\name{calcite_tile_group}
\alias{calcite_tile_group}
\title{Create a Calcite Tile Group Component}
\usage{
calcite_tile_group(
  ...,
  id = NULL,
  label = NULL,
  layout = NULL,
  alignment = NULL,
  scale = NULL,
  selection_mode = NULL,
  selection_appearance = NULL,
  disabled = NULL
)
}
\arguments{
\item{...}{Child \code{calcite_tile()} components}

\item{id}{Optional ID for the tile group (required for Shiny reactivity to track selection)}

\item{label}{Accessible name for the component (required for accessibility)}

\item{layout}{Defines the layout: "horizontal" for rows, "vertical" for a single column}

\item{alignment}{Specifies alignment of each tile's content: "start" or "center"}

\item{scale}{Specifies size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{selection_mode}{Specifies the selection mode: "none" (default), "single", "single-persist", or "multiple"}

\item{selection_appearance}{Specifies selection appearance: "icon" (checkmark/dot) or "border"}

\item{disabled}{When TRUE, interaction is prevented and component displays with lower opacity (default: FALSE)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Tile Group can be used to organize multiple Tile components within a layout.
It supports workflows and patterns using more than one Tile, with opt-in
selection modes for interactive workflows.
}
\details{
\subsection{Selection Modes}{
\itemize{
\item \code{"none"} - No selection allowed (default)
\item \code{"single"} - Only one tile can be selected at a time
\item \code{"single-persist"} - Only one tile selected, prevents de-selection
\item \code{"multiple"} - Any number of tiles can be selected
}
}

\subsection{Shiny Integration}{

When used in a Shiny app with an \code{id}, \code{calcite_tile_group()} returns a reactive
list containing component properties and emits events when selection changes.

\strong{Available properties:}
\itemize{
\item \verb{$selectedItems} - Array of selected tile IDs
\item \verb{$selectionMode} - Current selection mode
\item \verb{$layout} - Current layout
\item \verb{$disabled} - Whether the group is disabled
\item Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Watch for selection changes
observeEvent(input$my_tile_group$selectedItems, \{
  selected <- input$my_tile_group$selectedItems
  message("Selected tiles: ", paste(selected, collapse = ", "))
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic tile group
calcite_tile_group(
  label = "Role selection",
  calcite_tile(
    icon = "rangefinder",
    heading = "Field operator",
    description = "Create and edit Reports in the field"
  ),
  calcite_tile(
    icon = "knowledge-graph-dashboard",
    heading = "Office coordinator",
    description = "View and analyze Reports from the office"
  )
)

# Tile group with multiple selection
calcite_tile_group(
  id = "role_selector",
  label = "Select roles",
  selection_mode = "multiple",
  selection_appearance = "border",
  layout = "vertical",
  calcite_tile(
    id = "construction",
    icon = "wrench",
    heading = "Construction Worker",
    description = "Manage construction projects and coordinate teams"
  ),
  calcite_tile(
    id = "engineer",
    icon = "rangefinder",
    heading = "Civil Engineer",
    description = "Design infrastructure and ensure compliance"
  )
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/tile-group/}{Official Documentation}
}
