% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell.R
\name{page_navbar}
\alias{page_navbar}
\title{Create a Shell with Navigation Bar Layout}
\usage{
page_navbar(..., title = NULL, logo = NULL, nav_actions = NULL, footer = NULL)
}
\arguments{
\item{...}{Main content area}

\item{title}{Application title shown in the navigation header}

\item{logo}{Optional logo component for the navigation}

\item{nav_actions}{Optional actions for the navigation bar (placed in \code{content-end})}

\item{footer}{Optional footer content}
}
\value{
An object of class \code{calcite_component} containing a configured shell
}
\description{
A convenience function for creating a simple layout with a navigation header
and main content area. This is ideal for dashboard-style applications.
}
\examples{
page_navbar(
  title = "My Dashboard",
  nav_actions = list(
    calcite_action(icon = "gear", text = "Settings"),
    calcite_action(icon = "sign-out", text = "Logout")
  ),
  "Dashboard content here"
)
}
