% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell.R
\name{page_sidebar}
\alias{page_sidebar}
\title{Create a Shell with Sidebar Panel Layout}
\usage{
page_sidebar(
  ...,
  sidebar = NULL,
  title = NULL,
  position = c("start", "end"),
  width = c("m", "s", "l"),
  display_mode = c("dock", "overlay", "float-content", "float-all"),
  footer = NULL
)
}
\arguments{
\item{...}{Main content area (typically a \code{\link[=calcite_panel]{calcite_panel()}} or map view)}

\item{sidebar}{A \code{\link[=calcite_panel]{calcite_panel()}} for the sidebar. Typically contains
\code{\link[=calcite_block]{calcite_block()}} components with controls.}

\item{title}{Optional application title shown in a navigation header.}

\item{position}{Position of sidebar: \code{"start"} (left) or \code{"end"} (right).}

\item{width}{Width of the sidebar: \code{"s"}, \code{"m"}, or \code{"l"}.}

\item{display_mode}{Display mode for the shell panel: \code{"dock"}, \code{"overlay"},
\code{"float-content"}, or \code{"float-all"}. Default: \code{"dock"}.}

\item{footer}{Optional footer content}
}
\value{
An object of class \code{calcite_component} containing a configured shell
}
\description{
Similar to \code{\link[bslib:page_sidebar]{bslib::page_sidebar()}}, this creates a layout with a sidebar
panel and main content area — the easiest way to build a standard Calcite
app layout. Pass a \code{\link[=calcite_panel]{calcite_panel()}} as \code{sidebar}; it will be wrapped in a
\code{\link[=calcite_shell_panel]{calcite_shell_panel()}} automatically.
}
\examples{
page_sidebar(
  title = "Data Explorer",
  sidebar = calcite_panel(
    heading = "Filters",
    calcite_block(
      heading = "Options",
      collapsible = TRUE,
      expanded = TRUE
    )
  ),
  calcite_panel(heading = "Results")
)
}
