% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.detect.multiple.R
\name{call.detect.multiple}
\alias{call.detect.multiple}
\title{call.detect.multiple}
\usage{
call.detect.multiple(
  wave,
  threshold = 0.3,
  msmooth = c(500, 95),
  plot_it = FALSE,
  min_dur = 0.1,
  max_dur = 0.3,
  save_extra = 0,
  env_type = "Hilbert",
  bin_depth = 512,
  merge_overlap = FALSE
)
}
\arguments{
\item{wave}{wave object, e.g., from `load.wave` or `readWave`.}

\item{threshold}{rector of length 1 or 2. The fraction of the maximum of the
normalised envelope to use as threshold to detect start and end. If a vector
of length 2 is supplied, the first is used to detect the start and the
second to detect the end (in case of echo).}

\item{msmooth}{used as argument for the `seewave::env` function. *A vector
of length 2 to smooth the amplitude envelope with a mean sliding window. The
first component is the window length (in number of points). The second
component is the overlap between successive windows (in \%).* Default is
`c(500, 95)`.}

\item{plot_it}{logical, if `TRUE`, returns three-panel plot of wave form,
envelope and spectrogram to current plotting window. Default is `FALSE`.}

\item{min_dur}{numeric, the minimal duration in seconds for a detection to
be saved. Default is `0.1`.}

\item{max_dur}{numeric, the maximal duration in seconds for a detection to
be saved. Default is `0.3`.}

\item{save_extra}{numeric, how much to add to start and end time in seconds.
Can be used to make sure the whole vocalisation is included.}

\item{env_type}{character, what type of envelope to calculate. If `Hilbert`
returns the modulus (Mod)
of the analytical signal of wave obtained through the Hilbert transform
(hilbert) using seewave::env. If `summed` returns the summed absolute
amplitude. Default is `Hilbert`.}

\item{bin_depth}{numeric, how many samples to sum if env_type is `summed`.
Default is `512`.}

\item{merge_overlap}{logical, if `TRUE` overlapping detections (due to
`save_extra`) are merged. Default is `FALSE`.}
}
\value{
Returns a data frame with start = start time in samples and end =
end time in samples for each detection. Optionally also plots the wave form
and detections to current window.
}
\description{
Detects multiple calls in a wave object using an amplitude
envelope.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = readWave(local_file_1)
cd = call.detect.multiple(wave)

}
