% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shcal13}
\alias{shcal13}
\title{SHCal13 calibration curve}
\format{
\subsection{\code{shcal13}}{

A data frame with 5,141 rows and 5 columns providing the SHCal13 radiocarbon age
calibration curve on a calendar grid spanning from 50,000--0 cal yr BP:
\describe{
\item{calendar_age}{The calendar age (in cal yr BP)}
\item{c14_age}{The \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (1-\eqn{\sigma}) uncertainty in the \eqn{{}^{14}}C age}
\item{f14c}{The \eqn{{}^{14}}C age expressed as F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (1-\eqn{\sigma}) uncertainty in the F\eqn{{}^{14}}C concentration}
}
}
}
\source{
http://doi.org/10.2458/azu_js_rc.55.16783
}
\usage{
shcal13
}
\description{
The SHCal13 Southern Hemisphere radiocarbon age calibration curve
on a calendar grid spanning from 50,000--0 cal yr BP
(Before Present, 0 cal yr BP corresponds to 1950 CE). \cr \cr
\emph{Note:} This dataset provides \eqn{{}^{14}}C ages and F\eqn{{}^{14}}C values
on a calendar age grid. This is different from the \eqn{{}^{14}}C ages
and \eqn{{\Delta}^{14}}C values provided in oxcal .14c files.\cr \cr
\strong{Reference:} \cr Alan G Hogg, Quan Hua, Paul G Blackwell, Caitlin E Buck, Thomas P Guilderson,
Timothy J  Heaton, Mu Niu, Jonathan G Palmer, Paula J Reimer, Ron W Reimer,
Christian S M Turney, Susan R H Zimmerman. 2013.
SHCal13 Southern Hemisphere Calibration, 0-50,000 Years cal BP.
\emph{Radiocarbon} \strong{55}(4):1889--1903 https://doi.org/10.2458/azu_js_rc.55.16783. \cr \cr
}
\keyword{datasets}
