% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{two_normals}
\alias{two_normals}
\title{Example artificial data - Mixture of Normal Phases}
\format{
\subsection{\code{two_normals}}{

A data frame with 50 rows and 4 columns:
\describe{
\item{c14_age}{The simulated \eqn{{}^{14}}C age (in \eqn{{}^{14}}C yr BP)}
\item{c14_sig}{The (fixed) \eqn{{}^{14}}C age measurement uncertainty used in the simulation (set at 25 \eqn{{}^{14}}C yrs)}
\item{f14c}{The corresponding simulated values of F\eqn{{}^{14}}C concentration}
\item{f14c_sig}{The (fixed) corresponding F\eqn{{}^{14}}C measurement uncertainty used in the simulation}
}
}
}
\usage{
two_normals
}
\description{
50 simulated radiocarbon determinations for which the underlying calendar ages are
drawn from a mixture of two normals:
\deqn{f(\theta) = 0.45 N(3500, 200^2) + 0.55 N(5000, 100^2) }
i.e., a mixture of a normal centred around 3500 cal yr BP; and another
(slightly more concentrated/narrower) normal centred around 5000 cal yr BP. \cr \cr
The corresponding 50 radiocarbon ages were then simulated using the IntCal20 calibration curve
incorporating both the uncertainty in the calibration curve and a hypothetical measurement
uncertainty:
\deqn{X_i | \theta_i \sim N(m(\theta_i), \rho(\theta_i)^2 + \sigma_{i,\textrm{lab}}^2),}
where \eqn{m(\theta_i)} and \eqn{\rho(\theta_i)} are the IntCal20 pointwise
means and uncertainties; and \eqn{\sigma_{i,\textrm{lab}}}, the simulated
laboratory measurement uncertainty, was fixed at a common value of 25 \eqn{{}^{14}}C yrs. \cr \cr
This dataset is included simply to give some quick-to-run examples.
}
\examples{
# Plotting calendar age density underlying two_normals
# Useful for comparisons against estimation techniques
weights_true <- c(0.45, 0.55)
cluster_means_true_calBP <- c(3500, 5000)
cluster_precisions_true <- 1 / c(200, 100)^2

# Create mixture density
truedens <- function(t, w, truemean, trueprec) {
  dens <- 0
  for(i in 1:length(w)) {
    dens <- dens + w[i] * dnorm(t, mean = truemean[i], sd = 1/sqrt(trueprec[i]))
  }
  dens
}

# Visualise mixture
curve(truedens(
  x,
  w = weights_true,
  truemean = cluster_means_true_calBP,
  trueprec = cluster_precisions_true),
  from = 2500, to = 7000, n = 401,
  xlim = c(7000, 2500),
  xlab = "Calendar Age (cal yr BP)",
  ylab = "Density",
  col = "red"
)

}
\keyword{datasets}
