% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_missing.R
\name{ard_missing}
\alias{ard_missing}
\alias{ard_missing.data.frame}
\title{Missing ARD Statistics}
\usage{
ard_missing(data, ...)

\method{ard_missing}{data.frame}(
  data,
  variables,
  by = dplyr::group_vars(data),
  statistic = everything() ~ c("N_obs", "N_miss", "N_nonmiss", "p_miss", "p_nonmiss"),
  fmt_fun = NULL,
  stat_label = everything() ~ default_stat_labels(),
  fmt_fn = deprecated(),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{...}{Arguments passed to methods.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are tabulated by \strong{all combinations} of the columns specified.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) mean(x)))}.

The value assigned to each variable must also be a named list, where the names
are used to reference a function and the element is the function object.
Typically, this function will return a scalar statistic, but a function that
returns a named list of results is also acceptable, e.g.
\code{list(conf.low = -1, conf.high = 1)}. However, when errors occur, the messaging
will be less clear in this setting.}

\item{fmt_fun}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character()))}.}

\item{stat_label}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(mean = "Mean", sd = "SD")} or
\code{everything() ~ list(mean ~ "Mean", sd ~ "SD")}.}

\item{fmt_fn}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
an ARD data frame of class 'card'
}
\description{
Compute Analysis Results Data (ARD) for statistics related to data missingness.
}
\examples{
ard_missing(ADSL, by = "ARM", variables = "AGE")

ADSL |>
  dplyr::group_by(ARM) |>
  ard_missing(
    variables = "AGE",
    statistic = ~"N_miss"
  )
}
