% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram_cont.R
\name{cartogram_cont}
\alias{cartogram_cont}
\alias{cartogram_cont.SpatialPolygonsDataFrame}
\alias{cartogram_cont.sf}
\title{Calculate Contiguous Cartogram Boundaries}
\usage{
cartogram_cont(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05,
  verbose = FALSE
)

\method{cartogram_cont}{SpatialPolygonsDataFrame}(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05,
  verbose = FALSE
)

\method{cartogram_cont}{sf}(
  x,
  weight,
  itermax = 15,
  maxSizeError = 1.0001,
  prepare = "adjust",
  threshold = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{x}{a polygon or multiplogyon sf object}

\item{weight}{Name of the weighting variable in x}

\item{itermax}{Maximum iterations for the cartogram transformation, if maxSizeError ist not reached}

\item{maxSizeError}{Stop if meanSizeError is smaller than maxSizeError}

\item{prepare}{Weighting values are adjusted to reach convergence much earlier. Possible methods are 
"adjust", adjust values to restrict the mass vector to the quantiles defined by threshold and 1-threshold (default),
"remove", remove features with values lower than quantile at threshold,
"none", don't adjust weighting values}

\item{threshold}{Define threshold for data preparation}

\item{verbose}{print meanSizeError on each iteration}
}
\value{
An object of the same class as x
}
\description{
Construct a continuous area cartogram by a rubber sheet distortion algorithm (Dougenik et al. 1985)
}
\examples{
library(sf)
library(cartogram)

nc = st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# transform to NAD83 / UTM zone 16N
nc_utm <- st_transform(nc, 26916)

# Create cartogram
nc_utm_carto <- cartogram_cont(nc_utm, weight = "BIR74", itermax = 5)

# Plot 
par(mfrow=c(2,1))
plot(nc[,"BIR74"], main="original", key.pos = NULL, reset = FALSE)
plot(nc_utm_carto[,"BIR74"], main="distorted", key.pos = NULL, reset = FALSE)

}
\references{
Dougenik, J. A., Chrisman, N. R., & Niemeyer, D. R. (1985). An Algorithm To Construct Continuous Area Cartograms. In The Professional Geographer, 37(1), 75-81.
}
