% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar_sim.R
\name{covar_add}
\alias{covar_add}
\title{Add additional covariates to existing list of covariates}
\usage{
covar_add(covars, x, names = NULL, ...)
}
\arguments{
\item{covars}{list of covariates (data.frame's or data.table's)}

\item{x}{new covariates (function or list of functions/scalars)}

\item{names}{optional names of new covariates}

\item{...}{additional arguments to function \code{x} or functions in \code{x}}
}
\value{
matching format of covariates in \code{covars}
}
\description{
For use with \link{Trial} objects, this function makes it
possible to easily add additional covariates to an existing list of
covariates (in the form of a data.frame or data.table).
}
\examples{
# adding "fixed" treatment indicator in each period
n <- 5
xt <- function(n, ...) {
 covar_loggamma(n, normal.cor = 0.2) |>
   covar_add(list(a = 0, a = 1))
}
xt(n)
# adding randomized treatment indicator
xt <- function(n, ...) {
 covar_loggamma(n, normal.cor = 0.2) |>
   covar_add(list(a = rbinom(n, 1, 0.5), a = rbinom(n, 1, 0.5)))
}
xt(5)
# adding baseline covariates
xt <- function(n, ...) {
 covar_loggamma(n, normal.cor = 0.2) |>
   covar_add(rnorm(n), names = "w1") |> # data
   covar_add(list(w2 = rnorm(n))) |> # data
   covar_add(data.frame(w3 = rnorm(n))) |> # data
   covar_add(\(n) data.frame(w4 = rnorm(n))) |> # function
   covar_add(\(n) rnorm(n), names = "w5") # function
}
xt(5)
}
\author{
Klaus Kähler Holst
}
