% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ranked_retrieval_scores.r
\name{compute_ranked_retrieval_scores}
\alias{compute_ranked_retrieval_scores}
\title{Compute ranked retrieval scores}
\usage{
compute_ranked_retrieval_scores(
  predicted,
  gold_standard,
  doc_groups = NULL,
  drop_empty_groups = options::opt("drop_empty_groups"),
  progress = options::opt("progress")
)
}
\arguments{
\item{predicted}{Multi-label prediction results. Expects a data.frame with
columns \code{"label_id", "doc_id", "score"}.}

\item{gold_standard}{Expects a data.frame with columns \code{"label_id",
"doc_id"}.}

\item{doc_groups}{A two-column data.frame with a column \code{"doc_id"} and a
second column defining groups of documents to stratify results by. It is
recommended that groups are of type factor so that levels are not
implicitly dropped during bootstrap replications.}

\item{drop_empty_groups}{Should empty levels of factor variables be dropped in grouped set retrieval
computation? (Defaults to \code{TRUE}, overwritable using option 'casimir.drop_empty_groups' or environment variable 'R_CASIMIR_DROP_EMPTY_GROUPS')}

\item{progress}{Display progress bars for iterated computations (like bootstrap CI or
pr curves). (Defaults to \code{FALSE}, overwritable using option 'casimir.progress' or environment variable 'R_CASIMIR_PROGRESS')}
}
\value{
A data.frame with columns \code{"metric", "mode", "value", "support"}
and optional grouping variables supplied in \code{doc_groups}. Here,
\code{support} is defined as number of documents that contribute to the
document average in aggregation of the overall result.
}
\description{
This function computes the ranked retrieval scores Discounted
Cumulative Gain (DCG), Ideal Discounted Cumulative Gain (IDCG), Normalised
Discounted Cumulative Gain (NDCG) and Label Ranking Average Precision (LRAP).
Ranked retrieval, unlike set retrieval, assumes ordered predictions. Unlike
set retrieval metrics, ranked retrieval metrics are logically bound to a
document-wise evaluation. Thus, only the aggregation mode "doc-avg" is
available for these scores.
}
\examples{
# some dummy results
gold <- tibble::tribble(
  ~doc_id, ~label_id,
  "A", "a",
  "A", "b",
  "A", "c",
  "A", "d",
  "A", "e",
)

pred <- tibble::tribble(
  ~doc_id, ~label_id, ~score,
  "A", "f", 0.3277,
  "A", "e", 0.32172,
  "A", "b", 0.13517,
  "A", "g", 0.10134,
  "A", "h", 0.09152,
  "A", "a", 0.07483,
  "A", "i", 0.03649,
  "A", "j", 0.03551,
  "A", "k", 0.03397,
  "A", "c", 0.03364
)

results <- compute_ranked_retrieval_scores(
  pred,
  gold
)

}
