% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{topc}
\alias{topc}
\title{Apply top-c choices coding to a vector of scale data from a respondent}
\usage{
topc(x, c = 2, coding = "B")
}
\arguments{
\item{x}{input matrix}

\item{c}{number of top choices considered to be 'success'; other choices are 
considered to be 'failure' and are coded \code{0}}

\item{coding}{\code{"B"} (default) codes all successes as \code{1}; 
\code{"N"} codes all successes with their numeric coding}
}
\value{
matrix \code{X} with top-k coding applied
}
\description{
Apply top-c choices coding to a vector of scale data from a respondent
}
\examples{
# Generate some data
set.seed(123)
X <- matrix(sample(1:9, 100, replace = TRUE), nrow = 5)

# apply top-2 choice (T2C) coding
apply(X, 1, topc)
}
\references{
Castura, J.C., Meyners, M., Pohjanheimo, T., Varela, P., & Næs, T. (2023). 
An approach for clustering consumers by their top-box and top-choice responses. 
\emph{Journal of Sensory Studies}, e12860. \doi{10.1111/joss.12860}
}
\author{
J.C. Castura
}
