% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_test.R
\name{prop_test.numeric}
\alias{prop_test.numeric}
\title{Tests for equality of proportions}
\usage{
\method{prop_test}{numeric}(x, n, p = 0.5, method = c("wald", "wilson",
  "agresti-couli", "jeffreys", "modified wilson", "wilsoncc",
  "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting",
  "pratt"), alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95, correct = FALSE, exact = FALSE, ...)
}
\arguments{
\item{x}{a vector of counts.}

\item{n}{a vector of counts of trials}

\item{p}{a probability for the null hypothesis when testing a single proportion; ignored if comparing multiple proportions.}

\item{method}{a character string indicating method for calculating confidence interval, default is "wald". Options include,
wald, wilson, agresti-couli, jeffreys, modified wilson, wilsoncc modified jeffreys, clopper-pearson, arcsine, logit, witting, and pratt.}

\item{alternative}{character string specifying the alternative hypothesis. Possible options are "two.sided" (default),
"greater", or "less".}

\item{conf.level}{confidence level for confidence interval, default is 0.95.}

\item{correct}{a logical indicating whether Yate's continuity correction should be applied.}

\item{exact}{a logical indicating whether to output exact p-value, ignored if k-sample test.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "prop_test" containing the following components:

\item{x}{number of successes}
\item{n}{number of trials}
\item{p}{null proportion}
\item{statistic}{the value of Pearson's chi-squared test statistic}
\item{p_value}{p-value corresponding to chi-squared test statistic}
\item{df}{degrees of freedom}
\item{method}{the method used to calculate the confidence interval}
\item{method_ci}{confidence interval calculated using specified method}
\item{exact_ci}{exact confidence interval}
\item{exact_p}{p-value from exact test}
}
\description{
Conduct 1-sample tests of proportions and tests for equality of k proportions.
}
\examples{
prop_test(7, 50, method = "wald", p = 0.2)
prop_test(7, 50, method = "wald", p = 0.2, exact = TRUE)
}
