% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_caugi}
\alias{is_caugi}
\title{Is it a \code{caugi} graph?}
\usage{
is_caugi(x, throw_error = FALSE)
}
\arguments{
\item{x}{An object to check.}

\item{throw_error}{Logical; if \code{TRUE}, throws an error if \code{x} is not a
\code{caugi}.}
}
\value{
A logical value indicating whether the object is a \code{caugi}.
}
\description{
Checks if the given object is a \code{caugi}. Mostly used
internally to validate inputs.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  class = "DAG"
)

is_caugi(cg) # TRUE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{subgraph}()}
}
\concept{queries}
