% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{shd}
\alias{shd}
\title{Structural Hamming Distance}
\usage{
shd(cg1, cg2, normalized = FALSE)
}
\arguments{
\item{cg1}{A \code{caugi} object.}

\item{cg2}{A \code{caugi} object.}

\item{normalized}{Logical; if \code{TRUE}, returns the normalized SHD.}
}
\value{
An integer representing the Hamming Distance between the two graphs,
if \code{normalized = FALSE}, or a numeric between 0 and 1 if \code{normalized = TRUE}.
}
\description{
Compute the Structural Hamming Distance (SHD) between two
graphs.
}
\examples{
cg1 <- caugi(A \%-->\% B \%-->\% C, D \%-->\% C, class = "DAG")
cg2 <- caugi(A \%-->\% B \%-->\% C, D \%---\% C, class = "PDAG")
shd(cg1, cg2) # 1

}
\seealso{
Other metrics: 
\code{\link{aid}()},
\code{\link{hd}()}
}
\concept{metrics}
