% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{topological_sort}
\alias{topological_sort}
\title{Get a topological ordering of a DAG}
\usage{
topological_sort(cg)
}
\arguments{
\item{cg}{A \code{caugi} object of class DAG.}
}
\value{
A character vector of node names in topological order.
}
\description{
Returns a topological ordering of the nodes in a DAG. For every
directed edge u -> v in the graph, u will appear before v in the returned
ordering.
}
\examples{
# Simple DAG: A -> B -> C
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
topological_sort(cg) # Returns c("A", "B", "C") or equivalent valid ordering

# DAG with multiple valid orderings
cg2 <- caugi(
  A \%-->\% C,
  B \%-->\% C,
  class = "DAG"
)
# Could return c("A", "B", "C") or c("B", "A", "C")
topological_sort(cg2)

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()}
}
\concept{queries}
