% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind.decomp.R
\name{ind.decomp}
\alias{ind.decomp}
\title{Causal Decomposition with Individualized Interventions}
\usage{
ind.decomp(outcome, group, group.ref, risk.factor, intermediates, moderators,
  covariates, data, B, cluster = NULL)
}
\arguments{
\item{outcome}{a character string indicating the name of the outcome.}

\item{group}{a character string indicating the name of the social group indicator
such as race or gender.}

\item{group.ref}{reference group of the social group indicator.}

\item{risk.factor}{a character string indicating the name of the risk factor.}

\item{intermediates}{vector containing the name of intermediate confounders.}

\item{moderators}{a character string indicating the name of variables that have
heterogeneous effects on the outcome based on the risk factor.}

\item{covariates}{a vector containing the name of baseline covariate variable(s).}

\item{data}{The data set for analysis (data.frame).}

\item{B}{Number of bootstrapped samples in the causal decomposition analysis.}

\item{cluster}{a vector of cluster indicators for the bootstrap. If provided,
the cluster bootstrap is used. Default is 'NULL'.}
}
\value{
a matrix containing the point estimates for:
\enumerate{
\item the initial disparity and the proportion recommended for treatment,
\item the disparity remaining and percent reduction based on individualized conditional
effects,
\item the disparity remaining, disparity reduction, and percent reduction based on
individualized intervention effects.
}
It also returns the nonparametric bootstrap confidence intervals for each estimate.
}
\description{
‘ind.decomp’ estimates how much initial disparities would persist under two scenarios:
(i) Everyone follows the optimal treatment regime (OTR), yielding the Individualized
Controlled Direct Effect (ICDE); (ii) The proportion of individuals following the OTR is
equalized across groups, yielding the Individualized Interventional Effect (IIE).
This function implements the method proposed by Park, Kang, and Lee (2025+).
}
\details{
This function first estimates the initial disparity, defined
as the average difference in an outcome between groups within the same levels
of outcome-allowable covariates. Formally,
\deqn{\tau_{c} \equiv E[Y \mid R = 1, c] - E[Y \mid R = 0, c], \quad \text{for } c \in \mathcal{C}}
where \eqn{R = 1} is the comparison group and \eqn{R = 0} is the reference group.
The term \eqn{c \in \mathcal{C}} represents baseline covariates.

For individualized conditional effects, disparity remaining is defined as
\deqn{
  \zeta_{c}^{\mathrm{ICDE}}(d^{opt}) \equiv E[Y(d^{opt}) \mid R = 1, c] - E[Y(d^{opt}) \mid R = 0, c], \quad \text{for } c \in \mathcal{C}
  }
where \eqn{d^{opt}} is an optimal value for risk factor \eqn{M}. This definition of
disparity remaining states the difference in an outcome between the comparison
and reference groups after setting their risk factor \eqn{M} to the optimal value
obtained from the OTRs.

For individualized interventional effects, disparity reduction and disparity
remaining due to equalizing compliance rates across groups can be expressed as
follows:
\deqn{
  \delta_{c}^{\mathrm{IIE}}(1) \equiv E[Y \mid R = 1, c] - E[Y(K) \mid R = 1, c]
  }
\deqn{
  \zeta_{c}^{\mathrm{IIE}}(0) \equiv E[Y(K) \mid R = 1, c] - E[Y \mid R = 0, c]
  }
where \eqn{Y(K)} represents a potential outcome under the value of \eqn{M} that is
determined by a random draw from the compliance distribution of the reference
group among individuals with the same levels of target-factor-allowable
covariates. Disparity reduction (\eqn{\delta_{c}^{\mathrm{IIE}}(1)}) represents
the disparity in outcomes among a comparison group
after intervening to setting the compliance rate equal to that of a reference
group within the same target-factor-allowable covariate levels. Disparity
remaining (\eqn{\zeta_{c}^{\mathrm{IIE}}(0)}) quantifies the outcome difference
that persists between a comparison and reference group even after the intervention.
}
\examples{
data(idata)

# NOTE: We recommend using at least B = 500 boostrap replications.
results_unadj <- ind.decomp(outcome = "Y", group = "R", group.ref = "0", risk.factor = "M",
                           intermediates = c("X1", "X2", "X3"), moderators = c("X1", "X2"),
                           covariates = "C", data = idata, B = 50)
results_unadj                            
}
\references{
Park, S., Kang, S., & Lee, C. (2025). Simulation-Based Sensitivity Analysis in
Optimal Treatment Regimes and Causal Decomposition with Individualized Interventions.
arXiv preprint arXiv:2506.19010.
}
\seealso{
\code{\link{ind.sens}}
}
\author{
Soojin Park, University of California, Riverside, \email{soojinp@ucr.edu};
Suyeon Kang, University of Central Florida, \email{suyeon.kang@ucf.edu};
Karen Xu, University of California, Riverside, \email{karenxu@ucr.edu}.
}
