% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cdt}
\alias{plot_cdt}
\title{Plot causal distillation tree object}
\usage{
plot_cdt(cdt, show_digits = 2)
}
\arguments{
\item{cdt}{A causal distillation tree object, typically the output of
\code{\link{causalDT}}.}

\item{show_digits}{Number of digits to show in the plot labels. Default is 2.}
}
\value{
A plot of the causal distillation tree.
}
\description{
Visualize the subgroups (i.e., the student tree) from a causal
distillation tree object.
}
\examples{
\donttest{
n <- 200
p <- 10
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
Z <- rbinom(n, 1, 0.5)
Y <- 2 * Z * (X[, 1] > 0) + X[, 2] + rnorm(n, 0.1)

cdt <- causalDT(X, Y, Z)
plot_cdt(cdt)
}

}
