% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cat_data_mcar}
\alias{cat_data_mcar}
\title{Simulated Categorical Data with MCAR}
\format{
A data.frame with 1000 rows and 5 variables.
\describe{
\item{X1}{Categorical, 100 values set to NA (MCAR).}
\item{X2}{Categorical, 50 values set to NA (MCAR).}
\item{X3}{Categorical, 200 values set to NA (MCAR).}
\item{Z}{Categorical, no missing values.}
\item{Y}{Categorical, no missing values.}
}
}
\usage{
cat_data_mcar
}
\description{
A dataset based on \code{cat_data} where some values are randomly removed to simulate MCAR.
}
\details{
The R code used to generate this dataset is as follows:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{data(cat_data)
cat_data_mcar <- cat_data
n <- nrow(cat_data_mcar)
set.seed(1405)
cat_data_mcar$X1[sample(1:n, 100)] <- NA
cat_data_mcar$X2[sample(1:n, 50)] <- NA
cat_data_mcar$X3[sample(1:n, 200)] <- NA
}\if{html}{\out{</div>}}
}
\examples{
data(cat_data_mcar)
head(cat_data_mcar)

}
\seealso{
\link{cat_data}
}
\concept{dataset}
\keyword{datasets}
