% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fci.R
\name{fci}
\alias{fci}
\title{FCI Algorithm for Causal Discovery}
\usage{
fci(engine = c("tetrad", "pcalg"), test, alpha = 0.05, ...)
}
\arguments{
\item{engine}{Character; which engine to use. Must be one of:
\describe{
\item{\code{"tetrad"}}{\pkg{Tetrad} Java library.}
\item{\code{"pcalg"}}{\pkg{pcalg} R package.}
}}

\item{test}{Character; name of the conditional‐independence test.}

\item{alpha}{Numeric; significance level for the CI tests.}

\item{...}{Additional arguments passed to the chosen engine
(e.g. test or algorithm parameters).}
}
\description{
Run the FCI algorithm for causal discovery using one of several engines.
}
\details{
For specific details on the supported tests and parameters for each engine, see:
\itemize{
\item \link{TetradSearch} for \pkg{Tetrad},
\item \link{PcalgSearch} for \pkg{pcalg}.
}
}
\section{Recommendation}{

While it is possible to call the function returned directly with a data frame,
we recommend using \code{\link[=disco]{disco()}}. This provides a consistent interface and handles knowledge
integration.
}

\section{Value}{

A function that takes a single argument \code{data} (a data frame). When called,
this function returns a list containing:
\itemize{
\item \code{knowledge} A \code{Knowledge} object with the background knowledge
used in the causal discovery algorithm. See \code{\link[=knowledge]{knowledge()}} for how to construct it.
\item \code{caugi} A \code{\link[caugi:caugi]{caugi::caugi}} object representing the learned causal graph.
This graph is a PAG (Partial Ancestral Graph), but since PAGs are not yet
natively supported in \code{caugi}, it is currently stored with class \code{UNKNOWN}.
}
}

\examples{
data(tpc_example)

# Recommended path using disco()
fci_pcalg <- fci(engine = "pcalg", test = "fisher_z", alpha = 0.05)
disco(tpc_example, fci_pcalg)

# or using fci_pcalg directly
fci_pcalg(tpc_example)

# With all algorithm arguments specified
fci_pcalg <- fci(
  engine = "pcalg",
  test = "fisher_z",
  alpha = 0.05,
  skel.method = "original",
  type = "anytime",
  fixedGaps = NULL,
  fixedEdges = NULL,
  NAdelete = FALSE,
  m.max = 10,
  pdsep.max = 2,
  rules = c(rep(TRUE, 9), FALSE),
  doPdsep = FALSE,
  biCC = TRUE,
  conservative = TRUE,
  maj.rule = FALSE,
  numCores = 1,
  selectionBias = FALSE,
  jci = "1",
  verbose = FALSE
)
disco(tpc_example, fci_pcalg)

#### Using tetrad engine with tier knowledge ####
# Requires Tetrad to be installed
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  kn <- knowledge(
    tpc_example,
    tier(
      child ~ tidyselect::starts_with("child"),
      youth ~ tidyselect::starts_with("youth"),
      oldage ~ tidyselect::starts_with("oldage")
    )
  )

  # Recommended path using disco()
  fci_tetrad <- fci(engine = "tetrad", test = "fisher_z", alpha = 0.05)
  disco(tpc_example, fci_tetrad, knowledge = kn)

  # or using fci_tetrad directly
  fci_tetrad <- fci_tetrad |> set_knowledge(kn)
  fci_tetrad(tpc_example)
}

# With all algorithm arguments specified
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  fci_tetrad <- fci(
    engine = "tetrad",
    test = "fisher_z",
    alpha = 0.05,
    complete_rule_set_used = FALSE,
    max_disc_path_length = 4,
    depth = 10,
    stable_fas = FALSE,
    guarantee_pag = TRUE
  )
  disco(tpc_example, fci_tetrad)
}
}
\seealso{
Other causal discovery algorithms: 
\code{\link{boss}()},
\code{\link{boss_fci}()},
\code{\link{ges}()},
\code{\link{gfci}()},
\code{\link{grasp}()},
\code{\link{grasp_fci}()},
\code{\link{gs}()},
\code{\link{iamb-family}},
\code{\link{pc}()},
\code{\link{sp_fci}()},
\code{\link{tfci}()},
\code{\link{tges}()},
\code{\link{tpc}()}
}
\concept{causal discovery algorithms}
\concept{cd_algorithms}
