% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_dag}
\alias{sim_dag}
\title{Simulate a Random DAG}
\usage{
sim_dag(n, m = NULL, p = NULL)
}
\arguments{
\item{n}{The number of nodes.}

\item{m}{Integer in \verb{0, n*(n-1)/2}. Number of edges in the graph. Exactly one
of \code{m} or \code{p} must be supplied.}

\item{p}{Numeric in \verb{[0,1]}. Probability of edge creation. Exactly one of
\code{m} or \code{p} must be supplied.}
}
\value{
The sampled \code{caugi} object.
}
\description{
Simulates a random directed acyclic graph adjacency (DAG) matrix with \code{n} nodes
and either \code{m} edges, edge creation probability \code{p}, or edge creation
probability range \code{p_range}.
}
\examples{
# Simulate a DAG with 5 nodes and 3 edges
sim_dag(n = 5, m = 3)

# Simulate a DAG with 5 nodes and edge creation probability of 0.2
sim_dag(n = 5, p = 0.2)

}
\seealso{
\code{\link[caugi:generate_graph]{caugi::generate_graph()}}
}
