% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-data.R
\name{generate_qualitative_data_soo}
\alias{generate_qualitative_data_soo}
\title{Generate Qualitative Data (Selection-on-Observables)}
\usage{
generate_qualitative_data_soo(n, assignment, outcome_type)
}
\arguments{
\item{n}{Sample size.}

\item{assignment}{String controlling treatment assignment. Must be either \code{"randomized"} (random assignment) or \code{"observational"} (random assigment conditional on the generated covariates).}

\item{outcome_type}{String controlling the outcome type. Must be either \code{"multinomial"} or \code{"ordered"}. Affects how potential outcomes are generated.}
}
\value{
A list storing a data frame with the observed data, the true propensity score, and the true probabilities of shift.
}
\description{
Generate a synthetic data set with qualitative outcomes under a selection-on-observables design. The data include a binary treatment indicator and a matrix of covariates. The treatment is either
independent or conditionally (on the covariates) independent of potential outcomes, depending on users' choices.
}
\details{
\subsection{Outcome type}{

Potential outcomes are generated differently according to \code{outcome_type}. If \code{outcome_type == "multinomial"}, \code{\link{generate_qualitative_data_soo}} computes linear predictors for each class using the covariates:

\deqn{\eta_{mi} (d) = \beta_{m1}^d X_{i1} + \beta_{m2}^d X_{i2} + \beta_{m3}^d X_{i3}, \quad d = 0, 1,}

and then transforms \eqn{\eta_{mi} (d)} into valid probability distributions using the softmax function:

\deqn{P(Y_i(d) = m | X_i) = \frac{\exp(\eta_{mi} (d))}{\sum_{m'} \exp(\eta_{m'i}(d))}, \quad d = 0, 1.}

It then generates potential outcomes \eqn{Y_i(1)} and \eqn{Y_i(0)} by sampling from \{1, 2, 3\} using \eqn{P(Y_i(d) = m | X_i), \, d = 0, 1}.\cr

If instead \code{outcome_type == "ordered"}, \code{\link{generate_qualitative_data_soo}} first generates latent potential outcomes:

\deqn{Y_i^* (d) = \tau d + X_{i1} + X_{i2} + X_{i3} + N (0, 1), \quad d = 0, 1,}

with \eqn{\tau = 2}. It then constructs \eqn{Y_i (d)} by discretizing \eqn{Y_i^* (d)} using threshold parameters \eqn{\zeta_1 = 2} and \eqn{\zeta_2 = 4}. Then,

\deqn{P(Y_i(d) = m | X_i) = P(\zeta_{m-1} < Y_i^*(d) \leq \zeta_m | X_i) = \Phi (\zeta_m - \sum_j X_{ij} - \tau d) - \Phi (\zeta_{m-1} - \sum_j X_{ij} - \tau d), \quad d = 0, 1,}

which allows us to analytically compute the probabilities of shift.
}

\subsection{Treatment assignment}{

Treatment is always assigned as \eqn{D_i \sim \text{Bernoulli}(\pi(X_i))}. If \code{assignment == "randomized"}, then the propensity score is specified as \eqn{\pi(X_i) = P ( D_i = 1 | X_i)) = 0.5}.
If instead \code{assignment == "observational"}, then \eqn{\pi(X_i) = (X_{i1} + X_{i3}) / 2}.
}

\subsection{Other details}{

The function always generates three independent covariates from \eqn{U(0,1)}. Observed outcomes \eqn{Y_i} are always constructed using the usual observational rule.
}
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_qualitative_data_soo(100,
                                      assignment = "observational",
                                      outcome_type = "ordered")

data$pshifts}

}
\seealso{
\code{\link{generate_qualitative_data_iv}} \code{\link{generate_qualitative_data_rd}} \code{\link{generate_qualitative_data_did}}
}
\author{
Riccardo Di Francesco
}
