% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{plot.causalQual}
\alias{plot.causalQual}
\title{Plot Method for causalQual Objects}
\usage{
\method{plot}{causalQual}(x, hline = TRUE, ...)
}
\arguments{
\item{x}{An \code{causalQual} object.}

\item{hline}{Logical, whether to display an horizontal line at zero in the plot.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Plots an causalQual object.
}
\description{
Plots an \code{causalQual} object.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_qualitative_data_soo(1000, assignment = "observational",
                                      outcome_type = "ordered")
Y <- data$Y
D <- data$D
X <- data$X

## Estimate probabilities of shifts.
fit <- causalQual_soo(Y = Y, D = D, X = X, outcome_type = "ordered")
plot(fit)}

}
\seealso{
causalQual
}
\author{
Riccardo Di Francesco
}
