% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_parameters.R
\name{get_sample_parameters}
\alias{get_sample_parameters}
\title{Generate Sample Parameters for Node Dynamics}
\usage{
get_sample_parameters(
  n_nodes,
  beta_range = c(-1.5, -1),
  alpha_range = c(0.05, 0.3),
  delta_range = c(1, 5),
  sigma_range = c(0.01, 0.1),
  beta = NULL,
  alpha_self = NULL,
  delta = NULL,
  sigma = NULL,
  nodes = NULL
)
}
\arguments{
\item{n_nodes}{Integer number of nodes.}

\item{beta_range}{Length-2 numeric range for baseline/exogenous drive (used if \code{beta} is NULL).}

\item{alpha_range}{Length-2 numeric range for self-activation (used if \code{alpha_self} is NULL).}

\item{delta_range}{Length-2 numeric range for nonlinear amplification (used if \code{delta} is NULL).}

\item{sigma_range}{Length-2 numeric range for noise SD (used if \code{sigma} is NULL).}

\item{beta, alpha_self, delta, sigma}{Optional fixed numeric vectors. If length-1, recycled to \code{n_nodes}.}

\item{nodes}{Optional character vector of node names (length \code{n_nodes}) used to name outputs.}
}
\value{
A named list with elements \code{beta}, \code{alpha_self}, \code{delta}, \code{sigma} (each length \code{n_nodes}).
}
\description{
Returns a list of simulation parameters (domain-agnostic: nodes can be any variables).
If a parameter vector is not supplied, values are sampled i.i.d. from a uniform range.
}
