% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-linear-causal-problem.R
\name{create_linearcausalproblem}
\alias{create_linearcausalproblem}
\title{Create linear causal problem from causal model and effect}
\usage{
create_linearcausalproblem(causal_model, effectt)
}
\arguments{
\item{causal_model}{An object of class "causalmodel" as produce by \link{create_causalmodel}}

\item{effectt}{A character string that represents the causal effect of interest}
}
\value{
A an object of class "linearcausalproblem", which is a list with the
  following components. This list can be passed to \link{optimize_effect_2}
  which interfaces with the symbolic optimization program. Print and plot methods are also
  available. \describe{ 
  \item{variables}{Character vector of variable names
  of potential outcomes, these start with 'q' to match Balke's notation}
  \item{parameters}{Character vector of parameter names of observed
  probabilities, these start with 'p' to match Balke's notation}
  \item{constraints}{Character vector of parsed constraints}
  \item{objective}{Character string defining the objective to be optimized in
  terms of the variables} 
  \item{p.vals}{Matrix of all possible values of the
  observed data vector, corresponding to the list of parameters.}
  \item{q.vals}{Matrix of all possible values of the response function form
  of the potential outcomes, corresponding to the list of variables.}
  \item{parsed.query}{A nested list containing information on the parsed
  causal query.} 
  \item{objective.nonreduced}{The objective in terms of the
  original variables, before algebraic variable reduction. The nonreduced
  variables can be obtained by concatenating the columns of q.vals.}
  \item{response.functions}{List of response functions.} 
  \item{graph}{The graph as passed to the function.} 
  \item{R}{A matrix with coefficients
  relating the p.vals to the q.vals p = R * q} 
  \item{c0}{A vector of coefficients relating the q.vals to the 
  objective function theta = c0 * q} 
  \item{iqR}{A matrix with coefficients to represent the inequality
  constraints} }
}
\description{
A more flexible alternative to \link{analyze_graph} that takes as inputs the 
causal model and effect.
}
\details{
The effectt parameter describes your causal effect of interest. The effectt parameter must be of the form

\code{p{V11(X=a)=a; V12(X=a)=b;...} op1 p{V21(X=b)=a; V22(X=c)=b;...} op2 ...}

where Vij are names of variables in the graph, a, b are numeric values from 0:(nvals - 1), and op are either - or +. You can specify a single probability statement (i.e., no operator). Note that the probability statements begin with little p, and use curly braces, and items inside the probability statements are separated by ;. The variables may be potential outcomes which are denoted by parentheses. Variables may also be nested inside potential outcomes. Pure observations such as \code{p{Y = 1}} are not allowed if the left side contains any variables. 
There are 2 important rules to follow: 1) Only variables on the right side can be in the probability events, and if the left side is not empty: 2) none of the variables in the left side that are intervened upon can have any children in the left side, and all paths from the left to the right must be blocked by the intervention set. Here the intervention set is anything that is inside the smooth brackets (i.e., variable set to values).

 All of the following are valid effect statements:

\code{p{Y(X = 1) = 1} - p{Y(X = 0) = 1}}

\code{p{X(Z = 1) = 1; X(Z = 0) = 0}}

\code{p{Y(M(X = 0), X = 1) = 1} - p{Y(M(X = 0), X = 0) = 1}}
}
\examples{
### confounded exposure and outcome
b <- initialize_graph(igraph::graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y))
confmod <- create_causalmodel(graph = b, prob.form =  list(out = c("X", "Y"), cond = NULL))
create_linearcausalproblem(confmod, effectt = "p{Y(X = 1) = 1}")
}
