% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-parsing.R
\name{latex_bounds}
\alias{latex_bounds}
\title{Latex bounds equations}
\usage{
latex_bounds(bounds, parameters, prob.sym = "P", brackets = c("(", ")"))
}
\arguments{
\item{bounds}{Vector of bounds as returned by \link{optimize_effect_2}}

\item{parameters}{The parameters object as returned by \link{analyze_graph}}

\item{prob.sym}{Symbol to use for probability statements in latex, usually "P" or "pr"}

\item{brackets}{Length 2 vector with opening and closing bracket, usually \code{c("(", ")")}, or \code{c(" \{", "\}")}}
}
\value{
A character string with latex code for the bounds
}
\description{
Latex bounds equations
}
\examples{
b <- graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y)
V(b)$leftside <- c(0,0,0)
V(b)$latent <- c(0,0,1)
V(b)$nvals <- c(2,2,2)
E(b)$rlconnect <- E(b)$edge.monotone <- c(0, 0, 0)
obj <- analyze_graph(b, constraints = NULL, effectt = "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}")
bounds <- optimize_effect_2(obj)
latex_bounds(bounds$bounds, obj$parameters)
latex_bounds(bounds$bounds, obj$parameters, "Pr")
}
