% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causens_sf.R
\name{causens_sf}
\alias{causens_sf}
\title{Bayesian Estimation of ATE Subject to Unmeasured Confounding}
\usage{
causens_sf(
  trt_model,
  outcome,
  data,
  bootstrap = FALSE,
  B = 1000,
  seed = 123,
  ...
)
}
\arguments{
\item{trt_model}{A model formula specifying the treatment model.}

\item{outcome}{The name of the outcome variable.}

\item{data}{A data frame containing the exposure, outcome, and confounder
variables.}

\item{bootstrap}{A logical indicating whether to perform bootstrap estimation
of the 95\% confidence interval.}

\item{B}{If the bootstrap argument is TRUE, the number of bootstrap samples
to generate.}

\item{seed}{An integer to set the random seed for reproducibility.}

\item{...}{Additional arguments to be passed to the sensitivity function.}
}
\value{
A point estimate of the corrected ATE.
}
\description{
This function provides an estimate of the Average Treatment
Effect (ATE) using Bayesian modelling.
}
