% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_functions.R
\name{sample.z}
\alias{sample.z}
\title{Draw samples of independent normals (matrix) given previous sample, and maximal values}
\usage{
sample.z(mu, y, z)
}
\arguments{
\item{mu}{n by d matrix of latent means}

\item{y}{n-length vector of maximal indices}

\item{z}{n by d matrix of latent random variables}
}
\value{
A new sample of n by d matrix of latent random variables
}
\description{
Draw samples of independent normals (matrix) given previous sample, and maximal values
}
\examples{
set.seed(1)
n <- 100;  d <- 3
mu <- matrix(rnorm(n*d), n, d)
bound <- qnorm(1/d^(1/(d-1)))
mu[,1] <- bound
z <- mu
z[,-1] <- rnorm(length(mu[,-1]), mu[,-1], 1)
y <- apply(z, 1, which.max)
z.new <- sample.z(mu, y, z)
all(apply(z.new, 1, which.max) == y)
}
