% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_database.R
\name{lookup_id}
\alias{lookup_id}
\title{Lookup all available information on what studies a sample ID or patient ID belongs to}
\usage{
lookup_id(lookup_id = NULL, base_url = NULL)
}
\arguments{
\item{lookup_id}{a sample ID or patient ID}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of general info for sample of patient IDs given
}
\description{
This is a general look up function that can take a study ID or patient ID and return what samples
exist across entire cBioPortal website (depends on your base URL) that match that ID.
It will return which studies include that sample or patient.
}
\details{
This can also be useful to see all samples a particular patient has available across all studies on
cBioPortal (see also \code{get_samples_by_patient()}).
}
\examples{
\dontrun{
lookup_id <- c("P-0001453-T01-IM3", "P-0000004-T01-IM3", "TCGA-OR-A5JA")
x <- lookup_id(lookup_id = lookup_id,  base_url = 'www.cbioportal.org/api')
x
 }
}
