% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarks.r
\name{sparse_CCA_benchmarks}
\alias{sparse_CCA_benchmarks}
\title{Additional Benchmarks for Sparse CCA Methods}
\usage{
sparse_CCA_benchmarks(
  X_train,
  Y_train,
  S = NULL,
  rank = 2,
  kfolds = 5,
  method.type = "FIT_SAR_CV",
  lambdax = 10^seq(from = -3, to = 2, length = 10),
  lambday = c(0, 1e-07, 1e-06, 1e-05),
  standardize = TRUE
)
}
\arguments{
\item{X_train}{Matrix of predictors (n x p)}

\item{Y_train}{Matrix of responses (n x q)}

\item{S}{Optional covariance matrix (default is NULL, which computes it from X_train and Y_train)}

\item{rank}{Target rank for the CCA (default is 2)}

\item{kfolds}{Number of cross-validation folds (default is 5)}

\item{method.type}{Type of method to use for Sparse CCA (default is "FIT_SAR_CV"). Choices include "FIT_SAR_BIC", "FIT_SAR_CV", "Witten_Perm", "Witten.CV",  and "SCCA_Parkhomenko".}

\item{lambdax}{Vector of sparsity parameters for X (default is a sequence from 0 to 1 with step 0.1)}

\item{lambday}{Vector of sparsity parameters for Y (default is a sequence from 0 to 1 with step 0.1)}

\item{standardize}{Standardize (center and scale) the data matrices X and Y (default is TRUE) before analysis}
}
\value{
A matrix (p+q)x r containing the canonical directions for X and Y.
}
\description{
Additional Benchmarks for Sparse CCA Methods
}
