% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocator.R
\name{append_geoid}
\alias{append_geoid}
\title{Retrieve GEOID from the Census Geocoder by address}
\usage{
append_geoid(address, geoid_type = "bl")
}
\arguments{
\item{address}{A tibble/data frame with (at a minimum, others can be present)
either character columns street, city, and state OR numeric columns lat and
lon. Lat/lon columns take priority.}

\item{geoid_type}{GEOID level to return, \code{c('co', 'tr', 'bg', 'bl')}.
Defaults to block.}
}
\value{
the original tibble with GEOIDs appended as a new column called
  \code{geoid}.
}
\description{
Returns GEOID for 2010 geographies.
}
\details{
It is possible in some situations for the geolocator API to return a 500 error.
Repeating the call should avoid this.
}
\examples{
\dontrun{
airports <- dplyr::data_frame(
  street = "700 Catalina Dr", city = "Daytona Beach", state = "FL"
)
append_geoid(airports, 'tr')
}

}
