% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locale.R
\name{cc_location}
\alias{cc_location}
\alias{cc_elevation}
\alias{cc_macquarie}
\alias{cc_davis}
\alias{cc_mawson}
\alias{cc_casey}
\alias{cc_heard}
\alias{cc_kingston}
\title{Obtain tiled imagery by location query}
\usage{
cc_location(
  loc = NULL,
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_macquarie(
  loc = c(158.93835, -54.49871),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_davis(
  loc = c(77 + 58/60 + 3/3600, -(68 + 34/60 + 36/3600)),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_mawson(
  loc = c(62 + 52/60 + 27/3600, -(67 + 36/60 + 12/3600)),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_casey(
  loc = cbind(110 + 31/60 + 36/3600, -(66 + 16/60 + 57/3600)),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_heard(
  loc = c(73 + 30/60 + 30/3600, -(53 + 0 + 0/3600)),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_kingston(
  loc = c(147.2901, -42.98682),
  buffer = 5000,
  type = "mapbox.satellite",
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)

cc_elevation(
  loc = NULL,
  buffer = 5000,
  type = NULL,
  ...,
  zoom = NULL,
  max_tiles = NULL,
  debug = FALSE,
  dimension = NULL
)
}
\arguments{
\item{loc}{a longitude, latitude pair of coordinates, or a spatial object}

\item{buffer}{with in metres to extend around the location, ignored if 'loc' is a spatial object with extent}

\item{type}{character string of provider imagery type (see Details)}

\item{...}{deprecated arguments that \emph{used_to_be} passed to internal function now ignored since v 0.8.0 (see \code{\link[=get_tiles]{get_tiles()}})}

\item{zoom}{deprecated (use \code{dimension})}

\item{max_tiles}{deprecated}

\item{debug}{deprecated}

\item{dimension}{one or two numbers, used to determine the number of pixels width, height - set one to zero to let GDAL figure it out, or leave as NULL to get something suitable}
}
\value{
A \code{\link[terra:rast]{terra::rast()}} object, either with three layers (Red, Green, Blue) or with
a single layer in the case of \code{\link[=cc_elevation]{cc_elevation()}}.
}
\description{
Obtain imagery or elevation data by location query. The first argument
\code{loc} may be a spatial object (sp, raster, sf) or a 2-column matrix with a single
longitude and latitude value. Use \code{buffer} to define a width and height to pad
around the raw longitude and latitude in metres. If \code{loc} has an extent, then
\code{buffer} is ignored.
}
\details{
\code{cc_elevation} does extra work to unpack the DEM tiles from the RGB format.

Available types are 'elevation-tiles-prod' for AWS elevation tiles, and 'mapbox.satellite',
and 'mapbox.terrain-rgb', 'tasmap' or one of 'tasmap_street' (TTSA), 'tasmap_aerialphoto2020', 'tasmap_aerialphoto2021', 'tasmap_aerialphoto2022',
'tasmap_aerialphoto2023', 'tasmap_esgismapbookpublic', 'tasmap_hillshadegrey', 'tasmap_hillshade', 'tasmap_orthophoto',
'tasmap_simplebasemap', 'tasmap_tasmap100k', 'tasmap_tasmap250k', 'tasmap_tasmap25k', 'tasmap_tasmap500k', 'tasmap_tasmapraster', 'tasmap_topographicgrayscale', 'tasmap_topographic'.

Note that arguments \code{max_tiles} and \code{zoom} are mutually exclusive. One or both must be \code{NULL}. If
both are NULL then \code{max_tiles = 16L}.
}
\examples{
if (!is.null(get_api_key())) {

 img <- cc_location(cbind(147, -42), buffer = 1e5)

 ## this source does not need the Mapbox API, but we won't run the example unless it's set
 dem <- cc_kingston(buffer = 1e4, type = "elevation-tiles-prod")
 terra::plot(dem, col = grey(seq(0, 1, length = 94)))

 ## Mapbox imagery
 \donttest{\dontrun{
 im <- cc_macquarie()
 plotRGB(im)
 }}
 }
}
