% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_teams.R
\name{cfbd_team_info}
\alias{cfbd_team_info}
\title{\strong{Team info lookup}}
\usage{
cfbd_team_info(
  conference = NULL,
  only_fbs = TRUE,
  year = most_recent_cfb_season()
)
}
\arguments{
\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC,
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC
Required if year not provided}

\item{only_fbs}{(\emph{Logical} default TRUE): Filter for only returning FBS teams for a given year.
If year is left blank while only_fbs is TRUE, then will return values for most current year}

\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}). Filter for getting a list of major division team for a given year. Required if conference not provided and the \code{year} parameter is only supported if \code{only_fbs} is TRUE.}
}
\value{
\code{\link[=cfbd_team_info]{cfbd_team_info()}} - A data frame with 12 variables:
\describe{
\item{\code{team_id}: integer.}{Referencing team id.}
\item{\code{school}: character.}{Team name.}
\item{\code{mascot}: character.}{Team mascot.}
\item{\code{abbreviation}: character.}{Team abbreviations.}
\item{\code{alt_name1}: character.}{Team alternate name 1 (as it appears in \code{play_text}).}
\item{\code{alt_name2}: character.}{Team alternate name 2 (as it appears in \code{play_text}).}
\item{\code{alt_name3}: character.}{Team alternate name 3 (as it appears in \code{play_text}).}
\item{\code{conference}: character.}{Conference of team.}
\item{\code{division}: character.}{Division of team within the conference.}
\item{\code{classification}: character.}{Conference classification (fbs,fcs,ii,iii)}
\item{\code{color}: character.}{Team color (primary).}
\item{\code{alt_color}: character.}{Team color (alternate).}
\item{\code{logos}: character.}{Team logos.}
\item{\code{venue_id}: character.}{Referencing venue id.}
\item{\code{venue_name}: character.}{Stadium name.}
\item{\code{city}: character.}{Team/venue city.}
\item{\code{state}: character.}{Team/venue state.}
\item{\code{zip}: character.}{Team/venue zip code (someone double check Miami (FL) on if they're in the same zip code).}
\item{\code{country_code}: character.}{Team/venue country code.}
\item{\code{timezone}: character.}{Team/venue timezone.}
\item{\code{latitude}: character.}{Venue latitude.}
\item{\code{longitude}: character.}{Venue longitude.}
\item{\code{elevation}: character.}{Venue elevation.}
\item{\code{capacity}: character.}{Venue capacity.}
\item{\code{year_constructed}: character.}{Year the venue was constructed.}
\item{\code{grass}: character.}{TRUE/FALSE response on whether the field is grass or not (oh, and there are so many others).}
\item{\code{dome}: character.}{TRUE/FALSE flag for if the venue is a domed stadium.}
}
}
\description{
\strong{Team info lookup}
}
\examples{
\donttest{
  try(cfbd_team_info(conference = "SEC"))

  try(cfbd_team_info(conference = "Ind"))

  try(cfbd_team_info(year = 2019))
}
}
\seealso{
Other CFBD Teams: 
\code{\link{cfbd_team_matchup}()},
\code{\link{cfbd_team_matchup_records}()},
\code{\link{cfbd_team_roster}()},
\code{\link{cfbd_team_talent}()}
}
\concept{CFBD Teams}
\keyword{Teams}
