% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{CV.search.DP.regression}
\alias{CV.search.DP.regression}
\title{Grid search based on cross-validation of dynamic programming for regression change points localisation with \eqn{l_0} penalisation.}
\usage{
CV.search.DP.regression(y, X, gamma_set, lambda_set, delta, eps = 0.001)
}
\arguments{
\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time.}

\item{gamma_set}{A \code{numeric} vector of candidate tuning parameters associated with \eqn{l_0} penalty of DP.}

\item{lambda_set}{A \code{numeric} vector of candidate tuning parameters for lasso penalty.}

\item{delta}{A strictly positive \code{integer} scalar of minimum spacing.}

\item{eps}{A \code{numeric} scalar of precision level for convergence of lasso.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{A list of vector of estimated change points}
 \item{K_hat}{A list of scalar of number of estimated change points}
 \item{test_error}{A list of vector of testing errors (each row corresponding to each gamma, and each column corresponding to each lambda)}
 \item{train_error}{A list of vector of training errors}
}
\description{
Perform grid search to select tuning parameters gamma (for \eqn{l_0} penalty of DP) and lambda (for lasso penalty) based on cross-validation.
}
\examples{
d0 = 10
p = 20
n = 100
cpt_true = c(30, 70)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
gamma_set = c(0.01, 0.1, 1)
lambda_set = c(0.01, 0.1, 1, 3)
temp = CV.search.DP.regression(y = data$y, X = data$X, gamma_set, lambda_set, delta = 2)
temp$test_error # test error result
# find the indices of gamma_set and lambda_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
gamma_set[min_idx[1]]
lambda_set[min_idx[2]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
}
\references{
Rinaldo, Wang, Wen, Willett and Yu (2020) <arxiv:2010.10410>
}
\author{
Daren Wang
}
