% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle.R
\name{hurdle}
\alias{hurdle}
\title{Loglikelihood adjustments for pscl::hurdle fits}
\description{
NOTE: \emph{Hurdle models are currently not supported.}
}
\details{
Adjust the loglikelihood and the standard errors of a fitted \code{\link[pscl:hurdle]{pscl::hurdle()}}
model.

Note that the \code{\link[pscl:hurdle]{pscl::hurdle()}} model has to be run with the option \code{x = TRUE}
in order for the adjustment to execute properly. The functions
\code{\link[=residuals.chantrics]{residuals.chantrics()}} and \code{\link[=fitted]{fitted.chantrics()}} are currently
disabled for \code{hurdle} models. Additionally, sequential \code{\link[=anova.chantrics]{anova.chantrics()}}
are not available.
}
\section{Supported families}{

Within each family, any link function should work.
\itemize{
\item \code{geometric}
\item \code{poisson}
\item \code{negbin}
\item \code{binomial} (for the zero mass distribution only)
}
}

\examples{
# hurdle model from AER, pg. 139-140
library(pscl)
data("RecreationDemand", package = "AER")
rd_hurdle <- hurdle(trips ~ . | quality + income,
  data = RecreationDemand,
  dist = "negbin", x = TRUE
)
summary(rd_hurdle)

# adjust model
# adj_loglik(rd_hurdle)
}
\keyword{internal}
