# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/person/lt_LT/__init__.py

person_formats_lt_lt <- c(
  "{{first_names}} {{last_names}}",
  "{{first_names}} {{last_names}}",
  "{{last_names}}, {{first_names}}"
)

person_first_names_lt_lt <- c(
  "Tomas",
  "Lukas",
  "Mantas",
  "Deividas",
  "Arnas",
  "Art\u016bras",
  "Karolis",
  "Dovydas",
  "Dominykas",
  "Darius",
  "Edvinas",
  "Jonas",
  "Martynas",
  "Kajus",
  "Donatas",
  "Andrius",
  "Matas",
  "Rokas",
  "Augustas",
  "Danielius",
  "Mindaugas",
  "Paulius",
  "Marius",
  "Armandas",
  "Edgaras",
  "Jok\u016bbas",
  "Nedas",
  "Tadas",
  "Nerijus",
  "Simonas",
  "Vytautas",
  "Art\u016bras",
  "Robertas",
  "Eimantas",
  "Arijus",
  "Nojus",
  "Egidijus",
  "Aurimas",
  "Emilis",
  "Laurynas",
  "Edvardas",
  "Joris",
  "Pijus",
  "Erikas",
  "Domas",
  "Vilius",
  "Evaldas",
  "Justinas",
  "Aleksandras",
  "Kristupas",
  "Gabrielius",
  "Benas",
  "Gytis",
  "Arminas",
  "Vakris",
  "Tautvydas",
  "Domantas",
  "Justas",
  "Markas",
  "Antanas",
  "Ar\u016bnas",
  "Ernestas",
  "Aronas",
  "Vaidas",
  "\u0104\u017euolas",
  "Titas",
  "Giedrius",
  "Ignas",
  "Povilas",
  "Saulius",
  "Julius",
  "Arvydas",
  "K\u0119stutis",
  "Rytis",
  "Aistis",
  "Gediminas",
  "Algirdas",
  "Naglis",
  "Irmantas",
  "Rolandas",
  "Aivaras",
  "Simas",
  "Faustas",
  "Ram\u016bnas",
  "\u0160ar\u016bnas",
  "Gustas",
  "Tajus",
  "Dainius",
  "Arnoldas",
  "Linas",
  "Rojus",
  "Adomas",
  "\u017dygimantas",
  "Ri\u010dardas",
  "Orestas",
  "Kipras",
  "Juozas",
  "Audrius",
  "Romualdas",
  "Petras",
  "Eleonora",
  "Raminta",
  "Dovil\u0117",
  "Sandra",
  "Dominyka",
  "Ana",
  "Erika",
  "Kristina",
  "Gintar\u0117",
  "R\u016bta",
  "Edita",
  "Karina",
  "\u017divil\u0117",
  "Jolanta",
  "Radvil\u0117",
  "Ramun\u0117",
  "Svetlana",
  "Ugn\u0117",
  "Egl\u0117",
  "Viktorija",
  "Justina",
  "Brigita",
  "Rasa",
  "Marija",
  "Giedr\u0117",
  "Iveta",
  "Sonata",
  "Vitalija",
  "Adrija",
  "Goda",
  "Paulina",
  "Kornelija",
  "Liepa",
  "Vakar\u0117",
  "Milda",
  "Meda",
  "Vaida",
  "Izabel\u0117",
  "Jovita",
  "Irma",
  "\u017demyna",
  "Leila",
  "Rimant\u0117",
  "Mant\u0117",
  "Ryt\u0117",
  "Perla",
  "Greta",
  "Monika",
  "Ieva",
  "Indr\u0117",
  "Ema",
  "Aurelija",
  "Smilt\u0117",
  "Ingrida",
  "Simona",
  "Amelija",
  "Sigita",
  "Olivija",
  "Laurita",
  "Jor\u016bn\u0117",
  "Leticija",
  "Vigilija",
  "Med\u0117ja",
  "Laura",
  "Agn\u0117",
  "Evelina",
  "Kotryna",
  "L\u0117ja",
  "Au\u0161ra",
  "Neringa",
  "Gerda",
  "Jurgita",
  "Rusn\u0117",
  "Au\u0161rin\u0117",
  "Rita",
  "Elena",
  "Ineta",
  "Ligita",
  "Vasar\u0117",
  "V\u0117j\u016bn\u0117",
  "Ign\u0117",
  "Gyt\u0117",
  "Ariana",
  "Ariel\u0117",
  "Vyt\u0117",
  "Eidvil\u0117",
  "Karolina",
  "Migl\u0117",
  "Vilt\u0117",
  "Jolanta",
  "Enrika",
  "Aur\u0117ja",
  "Vanesa",
  "Darija",
  "Reda",
  "Milana",
  "Rugil\u0117",
  "Diana"
)

person_last_names_lt_lt <- c(
  "Kazlauskas",
  "Jankauskas",
  "Petrauskas",
  "Pocius",
  "Stankevi\u010dius",
  "Vsiliauskas",
  "\u017dukauskas",
  "Butkus",
  "Paulauskas",
  "Urbonas",
  "Kavaliauskas",
  "Sakalauskas",
  "\u017dukauskas",
  "Akelis",
  "Ambrasas",
  "Kairys",
  "Kalvaitis",
  "Kalvelis",
  "Kalv\u0117nas",
  "Kaupas",
  "Ki\u0161ka",
  "Gagys",
  "Gailius",
  "Gailys",
  "Gai\u017eauskas",
  "Gai\u010di\u016bnas",
  "Galdikas",
  "Gintalas",
  "Ginzburgas",
  "Grinius",
  "Gronskis",
  "Nagys",
  "Naujokas",
  "Naru\u0161is",
  "Naus\u0117da",
  "Po\u0161ka",
  "Povilonis"
)

person_lt_lt <- list(
  first_names = person_first_names_lt_lt,
  last_names = person_last_names_lt_lt
)

#' @title Person Provider for Lithuanian (Lithuania)
#' @inherit PersonProvider description details return
#' @export
#' @family lt
#' @family LT
#' @details Note for female and male components that we fall back on generic
#' versions if the locale
#' doesn't provide a male/female version.
#' e.g., if no female first name we use first
#' name
#' @examples
#' x <- PersonProvider_lt_LT$new()
#' x$locale
#' x$render()
#' x$first_name()
#' x$first_name_female()
#' x$first_name_male()
#' x$last_name()
#' x$last_name_female()
#' x$last_name_male()
PersonProvider_lt_LT <- R6::R6Class(
  "PersonProvider_lt_LT",
  inherit = PersonProvider,
  private = list(
    formats = person_formats_lt_lt,
    persons = person_lt_lt,
    locale_ = "lt_LT"
  )
)
