% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEBAYdes.R
\name{createEBAYdes}
\alias{createEBAYdes}
\title{Create eBay Product Description}
\usage{
createEBAYdes(
  Model = "gpt-5-nano",
  SelectedCode = TRUE,
  verbose = TRUE,
  SlowTone = FALSE
)
}
\arguments{
\item{Model}{The GPT-4 model to use for text generation. Default is "gpt-5-nano".}

\item{SelectedCode}{Whether to get the input from the selected code in RStudio. Default is TRUE.}

\item{verbose}{Whether to display progress information. Default is TRUE.}

\item{SlowTone}{Whether to print the output slowly. Default is FALSE.}
}
\value{
The generated eBay product description.
}
\description{
This function generates a product description for eBay listings in English.
It uses the GPT-4 model for text generation and can take input from either RStudio or the clipboard.
}
\details{
Create eBay Product Description
}
\examples{
\dontrun{
# Option 1
# Select some text in RStudio and then run the rstudio addins

# Option 2
# Copy the text into your clipboard then execute
createEBAYdes(Model = "gpt-4o-mini", SelectedCode = FALSE, verbose = TRUE)

# Option 3
# clipr the text into your clipboard then execute
clipr::write_clip("A new A100 GPU")
createEBAYdes(Model = "gpt-4o-mini", SelectedCode = FALSE, verbose = TRUE)
}
}
\author{
Satoshi Kume
}
