library(checkargs)
context("isBooleanOrNaVector")

test_that("isBooleanOrNaVector works for all arguments", {
  expect_identical(isBooleanOrNaVector(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaVector(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isBooleanOrNaVector(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isBooleanOrNaVector(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isBooleanOrNaVector(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isBooleanOrNaVector(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaVector(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isBooleanOrNaVector(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaVector(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
