% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxt01.R
\docType{data}
\name{coxt01_main}
\alias{coxt01_main}
\alias{coxt01_pre}
\alias{coxt01_post}
\alias{coxt01}
\title{\code{COXT01} (Default) Cox Regression Model Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
coxt01_main(
  adam_db,
  arm_var = "ARM",
  time_var = "AVAL",
  event_var = "EVENT",
  covariates = c("SEX", "RACE", "AAGE"),
  strata = NULL,
  lbl_vars = "Effect/Covariate Included in the Model",
  multivar = FALSE,
  ...
)

coxt01_pre(adam_db, arm_var = "ARM", ...)

coxt01_post(tlg, prune_0 = FALSE, ...)

coxt01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) the arm variable used for arm splitting.}

\item{time_var}{(\code{string}) the time variable in a Cox proportional hazards regression model.}

\item{event_var}{(\code{string}) the event variable in a Cox proportional hazards regression model.}

\item{covariates}{(\code{character}) will be fitted and the corresponding effect will be estimated.}

\item{strata}{(\code{character}) will be fitted for the stratified analysis.}

\item{lbl_vars}{(\code{string}) text label for the a Cox regression model variables.}

\item{multivar}{(\code{flag}) indicator of whether multivariate cox regression is conducted.}

\item{...}{Further arguments passed to \code{tern::control_coxreg()}.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
Cox models are the most commonly used methods to estimate the magnitude of the effect in survival analyses.
It assumes proportional hazards; that is, it assumes that the ratio of the hazards
of the two groups (e.g. two arms) is constant over time.
This ratio is referred to as the "hazard ratio" and is one of the most commonly reported metrics
to describe the effect size in survival analysis.
}
\details{
\itemize{
\item The reference arm will always the first level of \code{arm_var}. Please change the level if you want to
change the reference arms.
\item The table allows confidence level to be adjusted, default is two-sided 95\%.
\item The stratified analysis is with DISCRETE tie handling (equivalent to \code{tern::control_coxreg(ties = "exact")} in R).
\item Model includes treatment plus specified covariate(s) as factor(s) or numeric(s),
with \code{"SEX"}, \code{"RACE"} and \code{"AAGE"} as default candidates.
\item The selection of the covariates and whether or not there is a selection process
(vs. a fixed, pre-specified list) needs to be pre-specified.
\item For pairwise comparisons using the hazard ratio, the value for the control group is the denominator.
\item Keep zero-count rows unless overridden with \code{prune_0 = TRUE}.
}
}
\section{Functions}{
\itemize{
\item \code{coxt01_main()}: Main TLG function

\item \code{coxt01_pre()}: Preprocessing

\item \code{coxt01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adtte} table with \code{"PARAMCD"}, \code{"ARM"},
\code{"AVAL"}, \verb{"CNSR}, and the columns specified by \code{"covariates"} which is denoted as
\code{c("SEX", "RACE", "AAGE")} by default.
}
}
\examples{
library(dunlin)

proc_data <- log_filter(syn_data, PARAMCD == "CRSD", "adtte")
proc_data <- log_filter(proc_data, ARMCD != "ARM C", "adsl")
run(coxt01, proc_data)

run(coxt01, proc_data, covariates = c("SEX", "AAGE"), strata = c("RACE"), conf_level = 0.90)
}
\keyword{datasets}
