% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_probabilities.R
\name{choice_probabilities}
\alias{choice_probabilities}
\alias{compute_choice_probabilities}
\title{Define choice probabilities}
\usage{
choice_probabilities(
  data_frame,
  choice_only = TRUE,
  column_decider = "deciderID",
  column_occasion = NULL,
  cross_section = FALSE,
  column_probabilities = if (choice_only) "choice_probability"
)

compute_choice_probabilities(
  choice_parameters,
  choice_data,
  choice_effects,
  choice_only = FALSE,
  input_checks = TRUE,
  ...
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the choice probabilities.}

\item{choice_only}{[\code{logical(1)}]\cr
Only the probabilities for the chosen alternatives?}

\item{column_decider}{[\code{character(1)}]\cr
The name of the identifier column for deciders.}

\item{column_occasion}{[\code{character(1)} | \code{NULL}]\cr
The name of the identifier column for choice occasions (panel data).
Can be \code{NULL} for the cross-sectional case.}

\item{cross_section}{[\code{logical(1)}]\cr
Treat choice data as cross-sectional?}

\item{column_probabilities}{[\code{character()}]\cr
The column name of the \code{data_frame} with the choice probabilities for all
choice alternatives.

If \code{choice_only = TRUE}, it is the name of a single column that contains the
probabilities for the chosen alternatives.}

\item{choice_parameters}{[\code{choice_parameters} | \code{list}]\cr
Either a \code{\link{choice_parameters}} object or a list in optimization
space as returned by \code{\link{switch_parameter_space}}.}

\item{choice_data}{[\code{choice_data}]\cr
A \code{\link{choice_data}} object providing responses and covariates.}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object defining the specification.}

\item{input_checks}{[\code{logical(1)}]\cr
Should additional internal input checks be performed before computing the
probabilities?}

\item{...}{Passed to the underlying probability computation routine.}
}
\value{
A \code{choice_probabilities} S3 object (a data frame) that stores additional
metadata in attributes such as \code{column_probabilities}, \code{choice_only}, and the
identifier columns. These attributes are used by downstream helpers to
reconstruct the original structure.
}
\description{
The \code{choice_probabilities} object defines the choice probabilities.
\itemize{
\item \code{compute_choice_probabilities()} calculates the choice probabilities based
on the choice parameters and the choice data.
}
}
\examples{
data(train_choice)
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | time,
    error_term = "probit"
  ),
  choice_alternatives = choice_alternatives(
    J = 2, alternatives = c("A", "B")
  )
)
choice_parameters <- generate_choice_parameters(choice_effects)
choice_data <- choice_data(
  data_frame = train_choice,
  format = "wide",
  column_choice = "choice",
  column_decider = "deciderID",
  column_occasion = "occasionID"
)
compute_choice_probabilities(
  choice_parameters = choice_parameters,
  choice_data = choice_data,
  choice_effects = choice_effects,
  choice_only = TRUE
)
}
\keyword{probability}
