% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCase.R
\name{addCase}
\alias{addCase}
\title{Add observed case(s) to plot.}
\usage{
addCase(case = 1, latlong = FALSE, type = "observed", token = "both",
  text.size = 0.5, pch = 1, cex = 1, point.lwd = 2, col = "black",
  pos = 1)
}
\arguments{
\item{case}{Numeric or Character. Vector of case ID(s). "anchor" plots anchor cases; "fatality" plots all cases; "orthogonal" plot projected addresses.}

\item{latlong}{Logical.}

\item{type}{Character. Type of case: "observed" or "expected".}

\item{token}{Character. Type of token to plot: "point", "id" or "both".}

\item{text.size}{Numeric. Size of case ID text.}

\item{pch}{Numeric. pch.}

\item{cex}{Numeric. cex.}

\item{point.lwd}{Numeric. Point lwd.}

\item{col}{Character. Color.}

\item{pos}{Numeric. Text position.}
}
\description{
Add case(s), as "anchor", "fatality" or "orthogonal" as points or IDs, to a plot.
}
\note{
type, token, text.size, pch, cex, point.lwd and pos relevant only when case is numeric.
}
\examples{
\dontrun{
snowMap(add.cases = FALSE)
addCase(1)

snowMap(add.cases = FALSE)
addCase(100)
}
}
