% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_gcms.R
\name{cor_gcms}
\alias{cor_gcms}
\title{Compute and Plot Correlation Matrix for a Set of General Circulation Models}
\usage{
cor_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  method = "pearson"
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector with names of the variables to compare, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted. Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Whether to apply centering and scaling to the data. Default is \code{TRUE}.}

\item{method}{Character. The correlation method to use. Default is "pearson". Possible values are: "pearson", "kendall", or "spearman".}
}
\value{
A list containing two items: \code{cor_matrix} (the calculated correlations between GCMs) and \code{cor_plot} (a plot visualizing the correlation matrix).
}
\description{
This function computes and visualizes the correlation matrix for a set of General Circulation Models (GCMs) based on their variables.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
cor_gcms(s, var_names, study_area, method = "pearson")

}
\seealso{
\code{\link{transform_gcms}} \code{\link{flatten_gcms}} \code{\link{summary_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
