% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_entab.R
\name{call_entab}
\alias{call_entab}
\title{Call Entab}
\usage{
call_entab(
  path,
  data_format = c("wide", "long"),
  format_out = c("matrix", "data.frame", "data.table"),
  format_in = "",
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw")
)
}
\arguments{
\item{path}{Path to file.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{format_in}{Format of input.}

\item{read_metadata}{Whether to read metadata from file.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}
}
\value{
A chromatogram in the format specified by \code{format_out}
(retention time x wavelength).
}
\description{
Converts chromatography date files using \href{https://github.com/bovee/entab}{entab} parsers.
}
\seealso{
Other external parsers: 
\code{\link{call_openchrom}()},
\code{\link{call_rainbow}()},
\code{\link{read_thermoraw}()},
\code{\link{sp_converter}()},
\code{\link{uv_converter}()}
}
\concept{external parsers}
