% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_shimadzu_lcd.R
\name{read_sz_lcd_3d}
\alias{read_sz_lcd_3d}
\title{Read 'Shimadzu' LCD 3D data}
\usage{
read_sz_lcd_3d(
  path,
  format_out = "matrix",
  data_format = "wide",
  read_metadata = TRUE,
  metadata_format = "shimadzu_lcd",
  scale = TRUE
)
}
\arguments{
\item{path}{Path to 'Shimadzu' \code{.lcd} 3D data file.}

\item{format_out}{Matrix or data.frame.}

\item{data_format}{Either \code{wide} (default) or \code{long}.}

\item{read_metadata}{Logical. Whether to attach metadata.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{scale}{Whether to scale the data by the value factor.}
}
\value{
A 3D chromatogram from the PDA stream in \code{matrix} or
\code{data.frame} format, according to the value of \code{format_out}.
The chromatograms will be returned in \code{wide} or \code{long} format
according to the value of \code{data_format}.
}
\description{
Reads 3D PDA data stream from 'Shimadzu' \code{.lcd} files.
}
\details{
A parser to read PDA data from 'Shimadzu' \code{.lcd} files. LCD files are
encoded as 'Microsoft' OLE documents. The parser relies on the
\href{https://pypi.org/project/olefile/}{olefile} package in Python to unpack the
files. The PDA data is encoded in a stream called \code{PDA 3D Raw Data:3D Raw Data}.
The PDA data stream contains a segment for each retention time, beginning
with a 24-byte header.

The 24 byte header consists of the following fields:
\itemize{
\item 4 bytes: segment label (\code{17234}).
\item 4 bytes: Little-endian integer specifying the wavelength bandwidth (?).
\item 4 bytes: Little-endian integer specifying the number of wavelength values
in the segment.
\item 4 bytes: Little-endian integer specifying the total number of bytes in the segment.
\item 8 bytes of \code{00}s
}

Each segment is divided into two sub-segments, which begin and end with an
integer specifying the length of the sub-segment in bytes. All known values
in this data stream are little-endian and the data are delta-encoded. The
first hexadecimal digit of each value is a sign digit
specifying the number of bytes in the delta and whether the value is positive
or negative. The sign digit represents the number of hexadecimal digits used
to encode each value. Even numbered sign digits correspond to positive deltas,
whereas odd numbers indicate negative deltas. Positive values are encoded as
little-endian integers, while negative values are encoded as two's
complements. The value at each position is derived by subtracting the delta
at each position from the previous value.
}
\seealso{
Other 'Shimadzu' parsers: 
\code{\link{read_shimadzu}()},
\code{\link{read_shimadzu_gcd}()},
\code{\link{read_shimadzu_lcd}()},
\code{\link{read_shimadzu_qgd}()},
\code{\link{read_sz_lcd_2d}()}
}
\author{
Ethan Bass
}
\concept{'Shimadzu' parsers}
