% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage.R
\name{with_chrome_version}
\alias{with_chrome_version}
\alias{local_chrome_version}
\alias{local_chromote_chrome}
\alias{with_chromote_chrome}
\title{Use a specific version of Chrome or related binaries}
\usage{
with_chrome_version(
  version = "latest-stable",
  code,
  ...,
  binary = c("chrome", "chrome-headless-shell", "chromedriver"),
  platform = NULL,
  quiet = TRUE
)

local_chrome_version(
  version = "latest-stable",
  binary = c("chrome", "chrome-headless-shell", "chromedriver"),
  platform = NULL,
  ...,
  quiet = FALSE,
  .local_envir = parent.frame()
)

local_chromote_chrome(path, ..., .local_envir = parent.frame())

with_chromote_chrome(path, code, ...)
}
\arguments{
\item{version}{A character string specifying the version to use. The default
value is \code{"latest-stable"} to follow the latest stable release of Chrome.
For robust results, and to avoid frequently downloading new versions of
Chrome, use a fully qualified version number, e.g. \code{"133.0.6943.141"}.

If you specify a partial version, e.g. \code{"133"}, chromote will find the most
recent release matching that version, preferring to use the latest
\emph{installed} release that matches the partially-specified version. chromote
also supports a few special version names:
\itemize{
\item \code{"latest-installed"}: The latest version currently installed locally in
chromote's cache. If you don't have any installed versions of the binary,
chromote uses \code{"latest"}.
\item \code{"latest"}: The most recent Chrome for Testing release, which may be a
beta or canary release.
\item \code{"latest-stable"}, \code{"latest-beta"}, \code{"latest-extended"},
\code{"latest-canary"} or \code{"latest-dev"}: Installs the latest release from one
of Chrome's version channels, queried from the
\href{https://developer.chrome.com/docs/web-platform/versionhistory/reference#platform-identifiers}{VersionHistory API}.
\code{"latest-stable"} is the default value of \code{with_chrome_version()} and
\code{local_chrome_version()}.
\item \code{"system"}: Use the system-wide installation of Chrome.
}

Chromote also supports}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{...}{Ignored, used to require named arguments and for future feature
expansion.}

\item{binary}{A character string specifying which binary to
use. Must be one of \code{"chrome"}, \code{"chrome-headless-shell"}, or
\code{"chromedriver"}. Default is \code{"chrome"}.}

\item{platform}{A character string specifying the platform. If \code{NULL}
(default), the platform will be automatically detected.}

\item{quiet}{Whether to print a message indicating which version and binary
of Chrome is being used. By default, this message is suppressed for
\code{\link[=with_chrome_version]{with_chrome_version()}} and enabled for \code{\link[=local_chrome_version]{local_chrome_version()}}.}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}

\item{path}{A direct path to the Chrome (or Chrome-based) binary. See
\code{\link[=find_chrome]{find_chrome()}} for details or \code{\link[=chrome_versions_path]{chrome_versions_path()}} for paths
from the chromote-managed cache.}
}
\value{
Temporarily sets the \code{CHROMOTE_CHROME} environment variable and
returns the result of the \code{code} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#Experimental}{\figure{lifecycle-experimental.svg}{options: alt='[E]'}}}{\strong{[E]}}

This function downloads and sets up a specific version of Chrome, using the
\href{https://googlechromelabs.github.io/chrome-for-testing/}{Google Chrome for Testing builds}
for \code{chrome}, \code{chrome-headless-shell} or \code{chromedriver} for use with
chromote.

Managed Chrome installations is an experimental feature introduced in
chromote v0.5.0 and was inspired by similar features in
\href{https://playwright.dev/}{playwright}.
}
\details{
This function downloads the specified binary, if not already
available and configures \code{\link[=find_chrome]{find_chrome()}} to use the specified binary while
evaluating \code{code} or within the local scope. It uses the
"known-good-versions" list from the Google Chrome for Testing versions at
\url{https://googlechromelabs.github.io/chrome-for-testing/}.
}
\section{Functions}{
\itemize{
\item \code{with_chrome_version()}: Temporarily use a specific version of Chrome
during the evaluation of \code{code}.

\item \code{local_chrome_version()}: Use a specific version of Chrome within the
current scope.

\item \code{local_chromote_chrome()}: Use a specific Chrome, by path, within the
current scope.

\item \code{with_chromote_chrome()}: Temporarily use a specific Chrome version, by
path, for the evaluation of \code{code}.

}}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use the latest version of Chrome
local_chrome_version()

# Use a specific version of chrome-headless-shell
local_chrome_version("114.0.5735.90", binary = "chrome-headless-shell")
\dontshow{\}) # examplesIf}
}
