% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitChr.R
\name{splitChr}
\alias{splitChr}
\title{Split all chromosomes from the sorted chromosome list}
\usage{
splitChr(tex = tex, chr = chr, sex = FALSE, outdir = ".")
}
\arguments{
\item{tex}{The sorted chromosome list made by sortList function.}

\item{chr}{The chromosome number sequence, if the chromosome list is "single" which means a single character following "chr" in the Fasta identifier, be sure starting with 1 and ending with 9;
if the chromosome list is "double" which means two characters following "chr" in the Fasta identifier, be sure that starting with 10 but the ending can be changed.}

\item{sex}{Whether to output the sex chromosomes like X chromosome and Y chromosome.}

\item{outdir}{The output directory.}
}
\value{
Write the splitted chromosome Fasta file to separated txt files according to the chromosome number.
}
\description{
Split all chromosomes from the sorted chromosome list
}
\examples{
data(tex)
data(text)
#Simplify the Fasta id
text<- replaceText(type = "text",input = text)
#Subtract id
id <- subFasID(text = text)
#Sort the fasta according to the chromosome number in id
tex2<- sortList(id=id,tex = tex,chrsig = "single")
tex3 <- sortList(id=id,tex = tex,chrsig = "double")
outdir <- tempdir()
#Output the results
splitChr(tex = tex2,chr=seq(1,9),sex = TRUE,outdir = outdir)
splitChr(tex = tex3,chr=seq(10,22),sex = FALSE,outdir = outdir)
}
\author{
Shaoqian Ma
}
