% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplots.R
\name{add_barplot}
\alias{add_barplot}
\title{Add a bar plot to a chronicle report}
\usage{
add_barplot(
  report = "",
  dt,
  bars,
  value = NULL,
  break_bars_by = NULL,
  up_to_n_bars = 20,
  horizontal = FALSE,
  sort_by_value = FALSE,
  sort_decreasing = TRUE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  barplot_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added. Default is '', an empty report.}

\item{dt}{Table with the data for the plot.}

\item{bars}{Name of the columns containing the different groups.}

\item{value}{Name of the columns to use as values on the y axis of the plot. If NULL (default), counts will be used.}

\item{break_bars_by}{Name of the categorical variable used to break each bar}

\item{up_to_n_bars}{Plot up to this number of bars. If there are more distinct values in 'bars', the function will summarise them into an 'Others' category. Default is 20}

\item{horizontal}{Plot the bars horizontally. Default is FALSE.}

\item{sort_by_value}{Sort the bars by value. Default is FALSE.}

\item{sort_decreasing}{Sort the values decreasingly. Default is TRUE, but sort_by_value must also be TRUE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{barplot_title}{Title of the bar plot  section on the report. If NULL, chronicle will try to parse a generic title using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An rmarkdown file as a character string, now containing a chunk for adding the specified bar plot.
}
\description{
Add a bar plot to a chronicle report
}
\examples{
html_report <- add_barplot(report = '',
                           dt = iris,
                           bars = 'Species',
                           value = 'Sepal.Length')
cat(html_report)
}
